<?php
/**
* @version		$Id: text.php 14401 2010-01-26 14:10:00Z louis $
* @package		Joomla.Framework
* @subpackage	Parameter
* @copyright	Copyright (C) 2005 - 2010 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();
define('TEMPLATE', 'cloudbaseuniversity');

/**
 * Renders a text element
 *
 * @package 	Joomla.Framework
 * @subpackage		Parameter
 * @since		1.5
 */

class JElementColor extends JElement
{
	/**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Color';

	function fetchElement($name, $value, &$node, $control_name)
	{
		$document 	=& JFactory::getDocument();
		
		if (!defined('MOORAINBOW')) {
			
			$document->addStyleSheet('../templates/'.TEMPLATE.'/element/moorainbow/mooRainbow.css');
			$document->addScript('../templates/'.TEMPLATE.'/element/moorainbow/mooRainbow.js');
			define('MOORAINBOW',1);
		}
		
		echo '
			<script type="text/javascript">
			window.addEvent(\'domready\', function() {
				var r = new MooRainbow(\'myRainbow\', {
					\'startColor\': [58, 142, 246],
					\'onChange\': function(color) {
						$(\'myInput\').value = color.hex;
					}
				});
			});
			</script>';

		$size = ( $node->attributes('size') ? 'size="'.$node->attributes('size').'"' : '' );
		$class = ( $node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="text_area"' );
        /*
         * Required to avoid a cycle of encoding &
         * html_entity_decode was used in place of htmlspecialchars_decode because
         * htmlspecialchars_decode is not compatible with PHP 4
         */
        $value = htmlspecialchars(html_entity_decode($value, ENT_QUOTES), ENT_QUOTES);

		return '<input type="text" name="'.$control_name.'['.$name.']" id="myInput" value="'.$value.'" '.$class.' '.$size.' /><img id="myRainbow" src="../templates/'.TEMPLATE.'/element/moorainbow/images/rainbow.png" alt="[r]" width="16" height="16" />
';
	}
}
