$(function(){
    var ul = $('#upload ul');
    // Initialize the jQuery File Upload plugin
    $('#upload').fileupload({
        // This element will accept file drag/drop uploading
        dropZone: $('#drop'),
        // This function is called when a file is added to the queue;
        // either via the browse button, or via drag/drop:
        add: function (e, data) {
            var tpl = $('<li class="working"><input type="text" value="0" data-width="48" data-height="48"'+
                ' data-fgColor="#0788a5" data-readOnly="1" data-bgColor="#3e4043" /><p></p><span></span></li>');
			var file_size=data.files[0].size;
			var file_name=data.files[0].name
			var ext=file_name.substr(file_name.lastIndexOf(".")+1);
			
			if(ext.match(/(png|jpg|gif|jpeg|xpng)/i)){
				if(file_size<=3000000){
					 // Append the file name and file size
					tpl.find('p').text(data.files[0].name)
								 .append('<i>' + formatFileSize(file_size) + '</i>');

					// Add the HTML to the UL element
					//data.context = tpl.appendTo(ul);
					data.context=ul.html(tpl);
					// Initialize the knob plugin
					tpl.find('input').knob();

					// Listen for clicks on the cancel icon
					tpl.find('span').click(function(){

						if(tpl.hasClass('working')){
							jqXHR.abort();
						}

						tpl.fadeOut(function(){
							tpl.remove();
						});

					});
					// Automatically upload the file once it is added to the queue
					upload_1=false;
					var jqXHR = data.submit();
				}
				else{
					alert("File Size Too Large.! Max Of 2MB");
				}
			}
			else{
				alert("File Format Not Supported! Your Passport Photo Must Be An Image File");
			}
        },

        progress: function(e, data){
            // Calculate the completion percentage of the upload
            var progress = parseInt(data.loaded / data.total * 100, 10);

            // Update the hidden input field and trigger a change
            // so that the jQuery knob plugin knows to update the dial
            data.context.find('input').val(progress).change();

            if(progress == 100){
                data.context.removeClass('working');
            }
        },

        fail:function(e, data){
            // Something has gone wrong!
            data.context.addClass('error');
        },
		done:function(e, data){
			var r=$.parseJSON(data.result);
			if(r['status']=='success'){
				upload_1=true;
			}
			else{
				alert("There Was Error Uploading The File, Please Try Again. << "+r['status']+" >>");
			}
        }
    });

    // Prevent the default action when a file is dropped on the window
    $(document).on('drop dragover', function (e) {
        e.preventDefault();
    });

    // Helper function that formats the file sizes
    function formatFileSize(bytes) {
        if (typeof bytes !== 'number') {
            return '';
        }

        if (bytes >= 1000000000) {
            return (bytes / 1000000000).toFixed(2) + ' GB';
        }

        if (bytes >= 1000000) {
            return (bytes / 1000000).toFixed(2) + ' MB';
        }

        return (bytes / 1000).toFixed(2) + ' KB';
    }

});



$(function(){
    var ul = $('#upload_2 ul');
    // Initialize the jQuery File Upload plugin
    $('#upload_2').fileupload({
        // This element will accept file drag/drop uploading
        dropZone: $('#drop_2'),
        // This function is called when a file is added to the queue;
        // either via the browse button, or via drag/drop:
        add: function (e, data) {
            var tpl = $('<li class="working"><input type="text" value="0" data-width="48" data-height="48"'+
                ' data-fgColor="#0788a5" data-readOnly="1" data-bgColor="#3e4043" /><p></p><span></span></li>');
			var file_size=data.files[0].size;
			if(file_size<=3000000){
				// Append the file name and file size
				tpl.find('p').text(data.files[0].name)
							 .append('<i>' + formatFileSize(data.files[0].size) + '</i>');

				// Add the HTML to the UL element
				data.context = tpl.appendTo(ul);

				// Initialize the knob plugin
				tpl.find('input').knob();

				// Listen for clicks on the cancel icon
				tpl.find('span').click(function(){

					if(tpl.hasClass('working')){
						jqXHR.abort();
					}

					tpl.fadeOut(function(){
						tpl.remove();
					});

				});
				// Automatically upload the file once it is added to the queue
				upload_2=false;
				var jqXHR = data.submit();
			}
			else{
				alert("File Size Too Large. Max Of 2MB");
			}
        },

        progress: function(e, data){
            // Calculate the completion percentage of the upload
            var progress = parseInt(data.loaded / data.total * 100, 10);

            // Update the hidden input field and trigger a change
            // so that the jQuery knob plugin knows to update the dial
            data.context.find('input').val(progress).change();

            if(progress == 100){
                data.context.removeClass('working');
            }
        },
		fail:function(e, data){
            // Something has gone wrong!
            data.context.addClass('error');
        },
        done:function(e, data){
           upload_2=true;
        }
    });

    // Prevent the default action when a file is dropped on the window
    $(document).on('drop dragover', function (e) {
        e.preventDefault();
    });

    // Helper function that formats the file sizes
    function formatFileSize(bytes) {
        if (typeof bytes !== 'number') {
            return '';
        }

        if (bytes >= 1000000000) {
            return (bytes / 1000000000).toFixed(2) + ' GB';
        }

        if (bytes >= 1000000) {
            return (bytes / 1000000).toFixed(2) + ' MB';
        }

        return (bytes / 1000).toFixed(2) + ' KB';
    }

});