<?php
	class DB{
		public static $insert_id;
		public static $result_count=0;
		public static $limit_count=10;
		
		public static function insert($com){
			$query=self::query($com,'Error Inserting Data Into The Database');
			$id=mysqli_insert_id(SysproDb::$DBconnection);
			self::$insert_id=$id;
			return $id;
		}
		
		public static function select_all($com){
			$query=self::query($com,'Error Retrieving Data From The Database');
			$num=mysqli_num_rows($query);
			if($num>0){
				$arr_data=array();
				while($arr=mysqli_fetch_array($query)){
					$arr_data[]=$arr;
				}
				self::$result_count=$num;
				return $arr_data;
			}
			self::$result_count=$num;
			mysqli_free_result($query);
			return null;
		}
		
		public static function fetch_data($query){
			return mysqli_fetch_array($query);
		}
		
		public static function select_single($com){
			$query=self::query($com,'Error Retrieving Data From The Database');
			$arr=mysqli_fetch_array($query);
			return $arr;
		}
		
		public static function delete($com){
			$query=self::query($com,'Error Deleting Data From The Database');
			return true;
		}
		
		public static function update($com){
			$query=self::query($com,'Error Updating Database The Data');
			
			return mysqli_affected_rows(SysproDb::$DBconnection);
		}
		
		public static function num_rows($com){
			$query=self::query($com,'Error Retrieving Number Of Row On the Db Query');
			return mysqli_num_rows($query);
		}

		public static function num_query($query){
			return mysqli_num_rows($query);
		}
		
		public static function query($com,$errDesc=null){
			//$com=filter_var($com, FILTER_SANITIZE_STRING);
			$query=mysqli_query(SysproDb::$DBconnection,$com) or SysproDb::handle_mysql_exception(mysqli_error(SysproDb::$DBconnection),$errDesc);
			return $query;
		}
	}

	 class SysproDb{
		public static $DBconnection=null;
		public static $DBselect=null;
		
		public function __construct(){
			$con=mysqli_connect(DB_HOST,DB_USERNAME,DB_PASSWORD) or self::handle_mysql_exception(mysqli_errorno(),'Database Connection Failed');
			self::$DBconnection=$con;
			$db=mysqli_select_db($con,DB_NAME) or self::handle_mysql_exception(mysqli_error(self::$DBconnection),'Could Not Select The Database Provided');
			self::$DBselect=$db;
		}
		
		public static function handle_mysql_exception($errMsg,$errDesc){
			die("<div style='color:#999;border:5px solid rgba(255,0,0,0.3);width:40%;margin:0 auto;padding:10px;text-align:center;font-family:calibri'><h1 style='color:orangered'>$errDesc</h1><h2>$errMsg</h2></div>");
		}

		public function __destruct(){
			//mysqli_close(self::$DBconnection);
		}
	}
