<?php 
class View{
	function render($view=null,$model=null,$layout=null){
		if(!empty($layout)){
			if(file_exists(APP_LAYOUT_DIR . $layout)){
				require APP_LAYOUT_DIR . $layout;
			}
			else{
				echo 'layout not found';
				ThrowFileNotFoundException('The Layout File Not Found Exception Caught');
			}
		}
		else{
			if(file_exists(APP_DEFAULT_LAYOUT)){
				require APP_DEFAULT_LAYOUT;
			}
			else{
				ThrowFileNotFoundException('The Layout File Not Found Exception Caught');
			}
		}
	}
	
	function display($str=null){
		echo $str;
	}
}
function site_doctype($type='<!DOCTYPE html>'){
	echo $type;
}

function page_title($title){
	?>
	<title><?php echo $title; ?></title>
	<?php
}

function page_meta($name,$val=null){
	?>
	<meta name="<?php echo $name; ?>" content="<?php echo $val ?>" />
	<?php
}

function page_css($arg=null){
	?>
	<link rel="stylesheet" href="<?php print_file(CSS_DIR.$arg); ?>" />
	<?php
}

function page_jquery_lib($arg='jquery-1-8-2.js'){
	?>
	<script type="text/javascript" src="<?php print_file(JS_DIR.$arg); ?>"></script>
	<?php
}
function load_jquery_plugin($arg){
	?>
	<script type="text/javascript" src="<?php print_file(JS_DIR.$arg); ?>"></script>
	<?php
}
function page_header($arg){
	?>
		<div class="navbar navbar-inverse navbar-fixed-top" role="navigation">
			<a href="<?php print_link("index") ?>" style="font-size:1.8em;color:#fff;text-shadow:0 1px 1px rgba(0,0,0,0.2);padding:10px;text-align:center;display:block;font-weight:bold">
				<?php echo SITE_NAME ?>
			</a>
		</div>
		<div class="navbar-divider"></div>
	<?php
}

function page_footer($args='show'){
	?>
	<div style="height:20px;"></div>

	<?php
}

