<?php
	function ThrowFileNotFoundException($msg='File Not Found Exception Caught'){
		throw new Exception($msg);
	}
	function get_view($view_name,$filename='index.php'){
		return APP_VIEW_DIR . $view_name . "/". $filename;
	}
	function get_table_name($table){
		return DB_TABLE_PREFIX . $table;
	}

	function is_logged_in(){
		$f=false;
		if(isset($_SESSION['user_data'])){
			$f=true;
		}
		return $f;
	}

	/**
	 * Converts a MySQL Timestamp to Unix
	 *
	 * @param	int	MySQL timestamp YYYY-MM-DD HH:MM:SS
	 * @return	int	Unix timstamp
	 */
	function mysql_to_unix($time = ''){
		// We'll remove certain characters for backward compatibility
		// since the formatting changed with MySQL 4.1
		// YYYY-MM-DD HH:MM:SS

		$time = str_replace(array('-', ':', ' '), '', $time);

		// YYYYMMDDHHMMSS
		return mktime(
			substr($time, 8, 2),
			substr($time, 10, 2),
			substr($time, 12, 2),
			substr($time, 4, 2),
			substr($time, 6, 2),
			substr($time, 0, 4)
		);
	}

	function get_date_posted($mysql_date){	
		$date=$mysql_date;
		if(!is_numeric($mysql_date)){
			$date=mysql_to_unix($mysql_date);
		}
		$stf = 0;
		$cur_time = time();
		$diff = $cur_time - $date;
		$phrase = array('sec','min','hour','day','week','month','year','decade');
		$length = array(1,60,3600,86400,604800,2630880,31570560,315705600);
		for($i =sizeof($length)-1; ($i >=0)&&(($no =  $diff/$length[$i])<=1); $i--); if($i < 0) $i=0; $_time = $cur_time  -($diff%$length[$i]);
		$no = floor($no); if($no <> 1) $phrase[$i] .='s'; $value=sprintf("%d %s ",$no,$phrase[$i]);
		if(($stf == 1)&&($i >= 1)&&(($cur_tm-$_time) > 0)) $value .= time_ago($_time);
		
		return '<a title="'.date('l | d-M-Y ',$date).'At '.date('h : i a',$date).'" class="date_posted"><span class="txt">'.$value.'</span></a>';
	}

	function get_time_posted($mysql_date){	
		$date=$mysql_date;
		if(!is_numeric($mysql_date)){
			$date=mysql_to_unix($mysql_date);
		}
		return '<a title="'.date('l | d-M-Y ',$date).'At '.date('h : i a',$date).'" class="date_posted"><span class="txt">'.date('h:i',$date).'</span></a>';
	}

	function str_replace_symbols($str){
		$t=trim(preg_replace('/[^a-zA-Z0-9]+/i','-',strtolower($str)));
		return ($t);
	}
			
	function upload_file($path,$new_file_name){
		if(isset($_FILES['UPLOAD_FILE']) && $_FILES['UPLOAD_FILE']['error'] == 0){
			$extension = pathinfo($_FILES['UPLOAD_FILE']['name'], PATHINFO_EXTENSION);
			$fullPath="$path$new_file_name.$extension";
			if(move_uploaded_file($_FILES['UPLOAD_FILE']['tmp_name'], $fullPath)){
				echo '{"status":"success"}';
				return $fullPath;;
			}
			return null;
		}
	}
	
	function redirect_to_page($page_link){
		header("location:".SITE_ADDR. $page_link);
	}

	function set_session($session_name,$session_value){
		unset($_SESSION[$session_name]);
		$_SESSION[$session_name]=$session_value;
		return $_SESSION[$session_name];
	}

	function get_session($session_name){
		if(isset($_SESSION[$session_name])){
			return $_SESSION[$session_name];
		}
		return false;
	}

	function redirect_to_action($action_name){
		//header(SITE_ADDR. $action_name);
	}

	function authenticate_user($page=null,$action='exit-page'){
		$user=null;
		if(isset($_SESSION['user_data'])){
			$user=$_SESSION['user_data'];
		}
		else{
			if($action=='exit-page'){
				redirect_to_page($page."?y=not-Authenticated");
			}
			else{
				return null;
			}
		}
		return $user;
	}

	function get_form_field_value($field_value,$new_value=null){
		if(isset($field_value) && !empty($field_value)){
			return $field_value;
		}
		else{
			return $new_value;
		}
	}

	function print_link($link){
		echo SITE_ADDR.$link;
	}

	function load_countries(){
		$arr=array("United States","United Kingdom","Afghanistan","Albania","Algeria","American Samoa","Andorra","Angola","Anguilla","Antarctica","Antigua and Barbuda","Argentina","Armenia","Aruba","Australia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bermuda","Bhutan","Bolivia","Bosnia and Herzegovina","Botswana","Bouvet Island","Brazil","British Indian Ocean Territory","Brunei Darussalam","Bulgaria","Burkina Faso","Burundi","Cambodia","Cameroon","Canada","Cape Verde","Cayman Islands","Central African Republic","Chad","Chile","China","Christmas Island","Cocos (Keeling) Islands","Colombia","Comoros","Congo","Congo, The Democratic Republic of The","Cook Islands","Costa Rica","Cote D'ivoire","Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Falkland Islands (Malvinas)","Faroe Islands","Fiji","Finland","France","French Guiana","French Polynesia","French Southern Territories","Gabon","Gambia","Georgia","Germany","Ghana","Gibraltar","Greece","Greenland","Grenada","Guadeloupe","Guam","Guatemala","Guinea","Guinea-bissau","Guyana","Haiti","Heard Island and Mcdonald Islands","Holy See (Vatican City State)","Honduras","Hong Kong","Hungary","Iceland","India","Indonesia","Iran, Islamic Republic of","Iraq","Ireland","Israel","Italy","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea, Democratic People's Republic of","Korea, Republic of","Kuwait","Kyrgyzstan","Lao People's Democratic Republic","Latvia","Lebanon","Lesotho","Liberia","Libyan Arab Jamahiriya","Liechtenstein","Lithuania","Luxembourg","Macao","Macedonia, The Former Yugoslav Republic of","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Martinique","Mauritania","Mauritius","Mayotte","Mexico","Micronesia, Federated States of","Moldova, Republic of","Monaco","Mongolia","Montserrat","Morocco","Mozambique","Myanmar","Namibia","Nauru","Nepal","Netherlands","Netherlands Antilles","New Caledonia","New Zealand","Nicaragua","Niger","Nigeria","Niue","Norfolk Island","Northern Mariana Islands","Norway","Oman","Pakistan","Palau","Palestinian Territory, Occupied","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Pitcairn","Poland","Portugal","Puerto Rico","Qatar","Reunion","Romania","Russian Federation","Rwanda","Saint Helena","Saint Kitts and Nevis","Saint Lucia","Saint Pierre and Miquelon","Saint Vincent and The Grenadines","Samoa","San Marino","Sao Tome and Principe","Saudi Arabia","Senegal","Serbia and Montenegro","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Georgia and The South Sandwich Islands","Spain","Sri Lanka","Sudan","Suriname","Svalbard and Jan Mayen","Swaziland","Sweden","Switzerland","Syrian Arab Republic","Taiwan, Province of China","Tajikistan","Tanzania, United Republic of","Thailand","Timor-leste","Togo","Tokelau","Tonga","Trinidad and Tobago","Tunisia","Turkey","Turkmenistan","Turks and Caicos Islands","Tuvalu","Uganda","Ukraine","United Arab Emirates","United Kingdom","United States","United States Minor Outlying Islands","Uruguay","Uzbekistan","Vanuatu","Venezuela","Viet Nam","Virgin Islands, British","Virgin Islands, U.S.","Wallis and Futuna","Western Sahara","Yemen","Zambia","Zimbabwe");
		$data="";
		foreach($arr as $k){
			$data.="<option value='$k'>$k</option>";
		}
		return $data;
	}

	function print_file($file_link){
		echo $file_link;
	}
	
	function file_upload(){
		$file=$_FILES['UPLOAD_FILE']['tmp_name'];
		$fileName=$_FILES['UPLOAD_FILE']['name'];
		$t=rand(0,999) . time();
		$ext=get_file_extention($fileName);
		$path=UPLOAD_FILE_DIR . $t.'-'.$fileName;
		$maxSize=8;
		$fileSize=get_file_size($file);
		$error=0;
		if ($fileSize > $maxSize*1048576){
			$error=1;
		}
		else{
			if(!move_uploaded_file($file,$path)){
				$error=2;
			}
		}
		return array(SITE_ADDR.$path,$error,$fileName);
	}
	
	function blog_img_handler($user_id){
		$err=null;
		$img_path=null;
		if(isset($_FILES) && !empty($_FILES['UPLOAD_IMAGE']['name'])){
			$file=$_FILES['UPLOAD_IMAGE']['tmp_name'];
			$fileName=$_FILES['UPLOAD_IMAGE']['name'];
			$ext=get_file_extention($fileName);
			$fullPath=UPLOAD_IMG_DIR . "$user_id.$ext";
			$maxSize=3 * 1048576;
			$fileSize=get_file_size($file);
			$error=null;
			if ($fileSize > $maxSize){
				$error="File Size To Big ! (Max 3MB) ";
			}
			else{
				if($ext=='jpg' || $ext=='jpeg' || $ext=='pjpeg'){
					$maxWidth=760;
					$maxHeight=500;
					$image=imagecreatefromjpeg($file);
					
					$oldWidth=imagesx($image);
					$oldHeight=imagesy($image);
					
					if($oldWidth>=$oldHeight){
						if($oldWidth>$maxWidth){
							$scale=$maxWidth/$oldWidth;
						}
						else{
							$scale=1;
						}
					}
					else{
						if($oldHeight>$maxHeight){
							$scale=$maxHeight/$oldHeight;
						}
						else{
							$scale=1;
						}
					}
					$newWidth=ceil($scale*$oldWidth);
					$newHeight=ceil($scale*$oldHeight);
					$thumb=imagecreatetruecolor($newWidth,$newHeight);
					imagecopyresized($thumb, $image, 0, 0, 0, 0, $newWidth, $newHeight, $oldWidth, $oldHeight);
					imagejpeg($thumb,$fullPath,100);
					$img_path=SITE_ADDR . $fullPath;
				}
				else if($ext=='gif' || $ext=='png'){
					if(move_uploaded_file($file,$fullPath)){
						$img_path=SITE_ADDR . $fullPath;			
					}
					else{
						$err="File Not Uploaded (Please You Can try Again)";
					}
				}
				else{
					$err="File Format Not Supported (only .jpg, .gif, .png) Are Supported";
				}
			}
		}
		return array($img_path,$err);
	}
	function get_file_extention($str){
		$i = strrpos($str,".");
		if (!$i) { return ""; }
		$l = strlen($str) - $i;
		$ext = strtolower(substr($str,$i+1,$l));
		return $ext;
	}
	function get_file_size($file){
		return filesize($file);
	}
	function getUrl(){
		$url  = isset( $_SERVER['HTTPS'] ) && 'on' === $_SERVER['HTTPS'] ? 'https' : 'http';
		$url .= '://' . $_SERVER['SERVER_NAME'];
		$url .= in_array( $_SERVER['SERVER_PORT'], array('80', '443') ) ? '' : ':' . $_SERVER['SERVER_PORT'];
		$url .= $_SERVER['REQUEST_URI'];
		return $url;
	}

	function get_img_on_fly($img,$width,$height){
		$bname="$width-x-$height-".basename($img);
		$cached= UPLOAD_IMG_CACHE_DIR . $bname;
		if(file_exists($cached)){
			return $cached;
		}
		$resized=resize_img($img,$width,$height,$cached);
		return $resized;
	}

	function getHeight($image) {
		$size = getimagesize($image);
		$height = $size[1];
		return $height;
	}

	function getWidth($image) {
		$size = getimagesize($image);
		$width = $size[0];
		return $width;
	}

	function crop_image($thumb_image_name, $image, $width, $height, $start_width,$start_height, $scale){
		$ext=get_file_extention($image);
		$newImageWidth =100;
		$newImageHeight = 100;
		if($scale!=null){
			$newImageWidth = ceil($width * $scale);
			$newImageHeight = ceil($height * $scale);
		}
		if($ext=='jpg' || $ext=='jpeg' || $ext=='pjpeg'){
			$newImage = imagecreatetruecolor($newImageWidth,$newImageHeight);
			$source=imagecreatefromjpeg($image);
			imagecopyresampled($newImage,$source,0,0,$start_width,$start_height,$newImageWidth,$newImageHeight,$width,$height);
			imagejpeg($newImage,$thumb_image_name,90); 
			chmod($thumb_image_name, 0777);
			return $thumb_image_name;
		}
		return $image;
	}


	function resize_img($fimg,$maxWidth,$maxHeight,$save_path){
		$ext=get_file_extention($fimg);
		$oldWidth=getWidth($fimg);
		$oldHeight=getHeight($fimg);
		if($oldWidth>=$oldHeight){
			if($oldWidth>$maxWidth){
				$scale=$maxWidth/$oldWidth;
			}
			else{
				$scale=1;
			}
		}
		else{
			if($oldHeight>$maxHeight){
				$scale=$maxHeight/$oldHeight;
			}
			else{
				$scale=1;
			}
		}
		if($ext=='jpg' || $ext=='jpeg' || $ext=='pjpeg'){
			$image=imagecreatefromjpeg($fimg);		
			$newWidth=ceil($scale*$oldWidth);
			$newHeight=ceil($scale*$oldHeight);
			$thumb=imagecreatetruecolor($newWidth,$newHeight);
			imagecopyresampled($thumb, $image, 0, 0, 0, 0, $newWidth, $newHeight, $oldWidth, $oldHeight);
			imagejpeg($thumb,$save_path,100);
			return $save_path;
		}
		return $fimg;
	}


	function is_email($str){
		return (bool) filter_var($str, FILTER_VALIDATE_EMAIL);
	}
	function is_valid_name($str){
		if(strlen($str) > 1 && is_alpha_numeric_spaces($str)){
			return TRUE;
		}
		return FALSE;
	}
	function is_valid_telephone($str, $length){
		
	}
	function is_url($str){
		if (empty($str))
		{
			return FALSE;
		}
		elseif (preg_match('/^(?:([^:]*)\:)?\/\/(.+)$/', $str, $matches))
		{
			if (empty($matches[2]))
			{
				return FALSE;
			}
			elseif ( ! in_array($matches[1], array('http', 'https'), TRUE))
			{
				return FALSE;
			}

			$str = $matches[2];
		}

		$str = 'http://'.$str;

		// There's a bug affecting PHP 5.2.13, 5.3.2 that considers the
		// underscore to be a valid hostname character instead of a dash.
		// Reference: https://bugs.php.net/bug.php?id=51192
		if (version_compare(PHP_VERSION, '5.2.13', '==') === 0 OR version_compare(PHP_VERSION, '5.3.2', '==') === 0)
		{
			sscanf($str, 'http://%[^/]', $host);
			$str = substr_replace($str, strtr($host, array('_' => '-', '-' => '_')), 7, strlen($host));
		}

		return (filter_var($str, FILTER_VALIDATE_URL) !== FALSE);
	}

	function is_alpha_numeric_spaces($str){
		return (bool) preg_match('/^[A-Z0-9 ]+$/i', $str);
	}

	function is_regex_match($str, $regex){
		return (bool) preg_match($regex, $str);
	}