<?php
/**
 * @version		$Id: route.php 9764 2007-12-30 07:48:11Z ircmaxell $
 * @package		Joomla
 * @subpackage	Content
 * @copyright	Copyright (C) 2005 - 2008 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant to the
 * GNU General Public License, and as distributed it includes or is derivative
 * of works licensed under the GNU General Public License or other free or open
 * source software licenses. See COPYRIGHT.php for copyright notices and
 * details.
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// Component Helper
jimport('joomla.application.component.helper');

/**
 * Content Component Route Helper
 *
 * @static
 * @package		Joomla
 * @subpackage	JA News
 * @since 1.5
 */
class JanewsHelperRoute
{
  /**
	 * @param	int	The route of the section item
	 */
	function getSectionRoute($sectionid, $secttile)
	{
		$needles = array(
			'section' => (int) $sectionid,
		);

		//Create the link
		$link = 'index.php?option=com_janews&view=section&layout=blog&id='.$sectionid;

	  $itemid = JanewsHelperRoute::getMenuSection($sectionid, $secttile);
		if ($itemid)
		  $link .= '&Itemid='.$itemid;
		return $link;
	}

	function getCategoryRoute($catid, $sectionid, $cattitle, $sectitle)
	{
		$needles = array(
			'category' => (int) $catid,
			'section'  => (int) $sectionid
		);
    $catid = split(':',$catid);
    if (count($catid)==1) $catid[1] = '';
		$msecid = JanewsHelperRoute::getMenuSection($sectionid,$sectitle);
    JanewsHelperRoute::unpublishMenuCategoryContent($catid[0],$msecid);
    //Create the link
		$mcat = JanewsHelperRoute::getMenuCategory($catid, $cattitle, $msecid);
		if ($mcat)
		  $link = $mcat->link.'&Itemid='.$mcat->id;
		return $link;
	}

	function _findItem($needles)
	{
		$component =& JComponentHelper::getComponent('com_content');

		$menus	= &JApplication::getMenu('site', array());
		$items	= $menus->getItems('componentid', $component->id);

		$match = null;

		foreach($needles as $needle => $id)
		{
			foreach($items as $item)
			{
				if ((@$item->query['view'] == $needle) && (@$item->query['id'] == $id)
				 && (@$item->query['layout'] == 'blog') && (@$item->menutype == 'janews')) {
					$match = $item;
					break;
				}
			}

			if(isset($match)) {
				break;
			}
		}
		
		return $match;
	}
	
	function getMenuSection($secid,$sectitle)
	{
	  $component =& JComponentHelper::getComponent('com_janews');
	  $db = &JFactory::getDBO();

		$query = "SELECT *"
		  ." FROM #__menu"
		  ." WHERE menutype='janews'"
		  ." AND link='index.php?option=com_janews&view=section&layout=blog&id=".$secid."' AND componentid= ".$component->id;
		$db->setQuery($query);
		$menu = $db->loadObject();
		if ($menu) {
		  if ($menu->name != $sectitle) {
	    $query = "UPDATE #__menu"
	      ." SET name = ".$sectitle
	      ." WHERE id = ".$menu->id;
      $db->setQuery($query);
		  }
      return $menu->id;
		}
		return false;
	}
	
	function getMenuCategory($catid,$cattitle, $msecid)
	{
	  $component =& JComponentHelper::getComponent('com_content');
	  
	  $db = &JFactory::getDBO();
		$query = "SELECT *"
		  ." FROM #__menu"
		  ." WHERE menutype='janews'"
		  ." AND link LIKE 'index.php?option=com_%&view=category%&id=".$catid[0]."'"
		  ." AND parent=".$msecid;
		$db->setQuery($query);
		$menu = $db->loadObject();
		if ($menu) {
		  if ($menu->name != $cattitle || $menu->alias != $catid[1]) {
	    $query = "UPDATE #__menu"
	      ." SET name = '".$cattitle."' , alias = '".$catid[1]."'"
	      ." WHERE id = ".$menu->id;
      $db->setQuery($query);
		  $db->loadObject();
		  }
      return $menu;
		}
		return false;
	}
	
	function unpublishMenuCategoryContent($catid, $msecid)
	{
	  $component =& JComponentHelper::getComponent('com_content');
	  $db = JFactory::getDBO();
	  $query = "UPDATE #__menu"
      ." SET published = 0"
      ." WHERE published = 1 AND componentid = ".$component->id
      ." AND parent != ".$msecid
      ." AND link LIKE 'index.php?option=com_content&view=category%&id="."$catid'";
    $db->setQuery($query);
    $db->query();
    return true;
	}
}
?>