<?php
/**
 *	Joomla Countdown Module
 *
 * @author      Robert Concha <rob@cyfervoid.com>
 * @package	module
 * @copyright	Copyright (C) 2008 - 2009 Cyfervoid.com All rights reserved.
 */

defined('_JEXEC') or die('Restricted access');

class modCountHelper
{
    var $timezone   = '';
    var $targetDate = '';
    var $event_txt  = '';
    var $curtime    = '';
    
    function modCountHelper( $tzone, $tdate, $etxt )
    {
        // sending javascript code..
        header('Content-Type: text/javascript');

        $this->timezone = $tzone;
        $this->targetDate   = $tdate;
        $this->event_txt    = $etxt;
        // get the current time
        $this->curtime  = date("Y-m-d H:i:s");
    }
    
    function datediff($interval, $datefrom, $dateto, $using_timestamps = false)
    {
        if (!$using_timestamps) {
           $datefrom = strtotime($datefrom, 0);
           $dateto = strtotime($dateto, 0);
         }
         $difference = $dateto - $datefrom; // Difference in seconds
          
         switch($interval) {
          
           case 'yyyy': // Number of full years
       
             $years_difference = floor($difference / 31536000);
             if (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom), date("j", $datefrom), date("Y", $datefrom)+$years_difference) > $dateto) {
               $years_difference--;
             }
             if (mktime(date("H", $dateto), date("i", $dateto), date("s", $dateto), date("n", $dateto), date("j", $dateto), date("Y", $dateto)-($years_difference+1)) > $datefrom) {
               $years_difference++;
             }
             $datediff = $years_difference;
             break;
       
           case "q": // Number of full quarters
       
             $quarters_difference = floor($difference / 8035200);
             while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom)+($quarters_difference*3), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
               $months_difference++;
             }
             $quarters_difference--;
             $datediff = $quarters_difference;
             break;
       
           case "m": // Number of full months
       
             $months_difference = floor($difference / 2678400);
             while (mktime(date("H", $datefrom), date("i", $datefrom), date("s", $datefrom), date("n", $datefrom)+($months_difference), date("j", $dateto), date("Y", $datefrom)) < $dateto) {
               $months_difference++;
             }
             $months_difference--;
             $datediff = $months_difference;
             break;
       
           case 'y': // Difference between day numbers
       
             $datediff = date("z", $dateto) - date("z", $datefrom);
             break;
       
           case "d": // Number of full days
       
             $datediff = floor($difference / 86400);
             break;
       
           case "w": // Number of full weekdays
       
             $days_difference = floor($difference / 86400);
             $weeks_difference = floor($days_difference / 7); // Complete weeks
             $first_day = date("w", $datefrom);
             $days_remainder = floor($days_difference % 7);
             $odd_days = $first_day + $days_remainder; // Do we have a Saturday or Sunday in the remainder?
             if ($odd_days > 7) { // Sunday
               $days_remainder--;
             }
             if ($odd_days > 6) { // Saturday
               $days_remainder--;
             }
             $datediff = ($weeks_difference * 5) + $days_remainder;
             break;
       
           case "ww": // Number of full weeks
       
             $datediff = floor($difference / 604800);
             break;
       
           case "h": // Number of full hours
       
             $datediff = floor($difference / 3600);
             break;
       
           case "n": // Number of full minutes
       
             $datediff = floor($difference / 60);
             break;
       
           default: // Number of full seconds (default)
       
             $datediff = $difference;
             break;
         }    
       
         return $datediff;
    }

    function getCountDown( &$params, &$diff, &$front_txt )
    {
        $event_text = $this->event_txt;
        require(JModuleHelper::getLayoutPath('mod_count', 'countdown'));
    }
}
?>