<?php
/**
* @author		Joomlaku
* @package		Aku Accordion
* @version		1.5.2 2010-04-04 21:17:42
* @license		http://www.gnu.org/copyleft/gpl.html
* @copyright	Copyright (C) 2009 - 2010 Joomlaku. All Rights Reserved.
*/
defined('_JEXEC') or die('Restricted access');
require_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');
require_once('modules/mod_aku_accordion/scripts/images.php');
// Create ID
if (!isset($GLOBALS['akuacc'])) {
	$GLOBALS['akuacc'] = 1;
} else {
	$GLOBALS['akuacc']++;
}
// Module ID
$akuaccid		    = '-' . $GLOBALS['akuacc'];
// Params
// For Module
$sec				= $params->get('sec',1);
$cat				= $params->get('cat',1);
$counts				= $params->get('counts',5);
$ordering			= $params->get('ordering',1);
$introtext			= $params->get('introtext',150);
$specifics			= $params->get('specifics','');
$akumodule		    = JURI::base().'modules/mod_aku_accordion/';
// For Accordion
$show_date			= ($params->get('show_date',1) == 0)?'false':'true';
$show_more			= ($params->get('show_more',1) == 0)?'false':'true';
$show_image			= ($params->get('show_image',1) == 0)?'false':'true';
$image_width		= $params->get('image_width',64);
$image_height		= $params->get('image_height',64);
$load_jquery		= ($params->get("load_jquery", 1)  == 0)?"false":"true";
// Article Ordering
if($ordering == 1){
$order = 'RAND()';
}elseif($ordering == 2){
$order = 'ordering';
}elseif ($ordering == 3){
$order = 'hits DESC, created DESC';
}elseif ($ordering == 4){
$order = 'created DESC';
}elseif ($ordering == 5){
$order = 'modified DESC, created DESC';
}
// Add CSS and Script
$document =& JFactory::getDocument();
$document->addStylesheet($akumodule.'css/aku-style.css');
if($load_jquery == "true") :
$document->addScript($akumodule.'scripts/jquery-1.3.2.js');
$document->addScript($akumodule.'scripts/jquery-1.7.2.js');
endif;
$settings = "
	jQuery.noConflict();
	jQuery().ready(function(){
		jQuery('#akuacc".$akuaccid."').accordion({
		active:true, 
    	alwaysOpen:false,
		icons:{'header':'akuacc-closed','headerSelected':'akuacc-opened'}
		});
	});
";
$document->addScriptDeclaration($settings);
// Get Article
$db				=& JFactory::getDBO();
$user			=& JFactory::getUser();
$userId			= (int) $user->get('id');
$aid			= $user->get('aid', 0);
$contentConfig	= &JComponentHelper::getParams( 'com_content' );
$access			= !$contentConfig->get('shownoauth');
$nullDate		= $db->getNullDate();
$date			=& JFactory::getDate();
$now			= $date->toMySQL();
$where			= 'a.state = 1'
	. ' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )'
	. ' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )'
	;
if (!empty($specifics)) {
	$where .= ' AND a.id IN ('.$specifics.')';
} if(!empty($cat)) {
	$where .= ' AND cc.id = '.$cat.'';
} if(!empty($sec)) {
	$where .= ' AND s.id = '.$sec.'';
}
$sql = 'SELECT a.*, ' .
' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'. 
' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug,'.
'cc.title as cattitle,'.
's.title as sectitle'.

	' FROM #__content AS a' .
	($show_front == '0' ? ' LEFT JOIN #__content_frontpage AS f ON f.content_id = a.id' : '') .
	($show_front == '2' ? ' INNER JOIN #__content_frontpage AS f ON f.content_id = a.id' : '') .
	' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
	' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
	' WHERE '. $where .'' .
	($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
	($catid && $show_front != 2 ? $catCondition : '').
    ($secid && $show_front != 2 ? $secCondition : '').
    ($show_front == '0' ? ' AND f.content_id IS NULL ' : '').
	' AND s.published = 1' .
	' AND cc.published = 1' .
	' ORDER BY '.$order .' LIMIT 0,'.$counts.'';

$db->setQuery( $sql );
$load_items = $db->loadObjectList();
$core = array();
foreach ( $load_items as $row ) {
	$akuacc = array(
		'date' => JHTML::_('date', $row->created, JText::_('DATE_FORMAT_LC3')),
		'link' => ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid),
		'title' => $row->title,
		'imageurl' => $imageurl = akuacc_image($row),
		'introtext' =>substr(strip_tags($row->introtext),0,$introtext)
    );
  $acc[] = $akuacc;
}
// Get Layout
require(JModuleHelper::getLayoutPath('mod_aku_accordion'));
?>