<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;


class ResultPortalController extends Controller
{
    //

    public function fetchCgpa(Request $req){

        $cgpa = 0.0;
        $tgpa = 0.0;
        $thrs = 0;

         $sql =  "SELECT `tblprogcourses`.`crdhrs` AS `hrs`, `tgp` FROM `tblprogcourses`, `tblapprgds` WHERE `tblprogcourses`.`crscode` = `tblapprgds`.`crsid` AND `tblprogcourses`.`prgcode` = '$req->prog' AND `studid` = '$req->stuid'";
        
         $rows = DB::select(DB::raw($sql));   
         
        if(count($rows)>0){

        foreach($rows as $row){
         $tgpa += $row->tgp;
         $thrs += $row->hrs;
        }

        if($thrs != 0){
            $cgpa = round($tgpa/$thrs, 2);
        }

        return response()->json($cgpa, 200); 
    }
}
    

    public function semesterGrades(Request $req){

         $sql =  "SELECT `tblprogcourses`.`crstitle` AS `title`, `tblprogcourses`.`crdhrs` AS `hrs`, ROUND(`crdhrs` * `ggp`, 2) AS `mult`, `courseid`, `roundscore`, `grade`, `ggp` FROM `tblprogcourses`, `gradesheet` WHERE `gradesheet`.`courseid` = `tblprogcourses`.`crscode` AND `tblprogcourses`.`prgcode` = '$req->prog' AND `studentid` = '$req->stuid'";
        
         $rows = DB::select(DB::raw($sql));   
         
        if(count($rows)>0){

         $credhrs = 0;
         $tgp = 0.0;
         $gpa = 0.0;

        foreach($rows as $row){
         $tgp += $row->mult;
         $credhrs += $row->hrs;
        }

        if($credhrs != 0){
            $gpa = round($tgp/$credhrs, 2);
        }

        $data = array(
            'courses' => $rows,
            'gpa' => $gpa
        );
      }
         
        return response()->json($data, 200);   
    }

    

    public function semesterCompletion(Request $req){

        $semesters = ["One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight"];

        $completed = [];
        $uncompleted = [];        


        for($i=1; $i<=8; $i++){

            $sql =  "SELECT `crscode`, `crstitle`, `crdhrs` FROM `tblprogcourses` WHERE `prgcode` = '$req->prog' AND `trm` = 'Sem $i' AND `run` = 'Yes'";

            $rows = DB::select(DB::raw($sql));

            $num_courses = count($rows); 
            $num_comp_courses = 0;
            $gpa = 0.0;
            $credhrs = 0;
            $tgp = 0.0;

            foreach($rows as $row){

                $csql = "SELECT `tgp` FROM `tblapprgds` WHERE `crsid` = '$row->crscode' AND `studid` = '$req->stuid'";

                $crows = DB::select(DB::raw($csql));

                if(count($crows)>0){
                    $num_comp_courses += 1;
                    $credhrs += $row->crdhrs; 
                    foreach($crows as $crow){
                        $tgp += $crow->tgp;
                    }
                }
            }
           
            if($credhrs != 0){
                $gpa = round($tgp/$credhrs, 2);
            }

        if($num_courses == $num_comp_courses){
            array_push($completed,array(
                'sem'=>$semesters[$i-1],
                'courses'=>$rows,
                'num_courses'=>$num_courses,
                'num_comp_courses'=>$num_comp_courses,
                'tgp' => $tgp,
                'hrs' => $credhrs,
                'gpa'=>$gpa
             ));
        }

        else{
            array_push($uncompleted,array(
                'sem'=>$semesters[$i-1],
                'courses'=>$rows,
                'num_courses'=>$num_courses,
                'num_comp_courses'=>$num_comp_courses,
                'tgp' => $tgp,
                'hrs' => $credhrs,
                'gpa'=>$gpa
             ));
        }
    
    }

        $data = array(
            'completed' => $completed,
            'uncompleted' => $uncompleted,
        );
            
     
         return response()->json($data, 200);   
    }


    public function fetchBacklog(Request $req){

        $sql =  "SELECT `tblprogcourses`.`crstitle` AS `title`, `tblprogcourses`.`crdhrs` AS `hrs` FROM `tblprogcourses`, `tblapprgds` WHERE `crsscore` < 60 AND `tblprogcourses`.`crscode` = `tblapprgds`.`crsid` AND `tblprogcourses`.`prgcode` = '$req->prog' AND `studid` = '$req->stuid'";
    
        $rows = DB::select(DB::raw($sql));   

        return response()->json($rows, 200); 
    }


    public function fetchUncompleted(Request $req){

        $courses = [];

        $sql =  "SELECT `crscode`, `crstitle`, `crdhrs` FROM `tblprogcourses` WHERE `prgcode` = '$req->prog' AND `run` = 'Yes'";

            $rows = DB::select(DB::raw($sql));

            foreach($rows as $row){

                $csql = "SELECT `tgp` FROM `tblapprgds` WHERE `crsid` = '$row->crscode' AND `studid` = '$req->stuid'";

                $crows = DB::select(DB::raw($csql));

                if(count($crows)==0){
                    array_push($courses,array(
                        'title'=>$row->crstitle,
                        'code'=>$row->crscode,
                        'hrs' =>$row->crdhrs,
                    ));  
                }
    }
   
    return response()->json($courses, 200); 
}

}
