<?php

namespace App\Http\Controllers;

use App\Models\SchoolEvents;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;


class EventsManagerController extends Controller
{
    //
    public function createEvent(Request $req){

    $host = $req->getHttpHost();

    $path = "ait_logo.png";

    if($req->image != "default"){

        $rand = Str::random(30);

        // $destinationPath = public_path('images\\events');
        // file_put_contents("$destinationPath\\$rand.png", base64_decode($req->image));
        
        $newname = time() . '_' . $rand;
        $path = public_path('images/events' . '/');
        file_put_contents($path.$newname.".png", base64_decode($req->image));
        $path = "events/$newname.png";
    }

    $date = date("Y-m-d H:i:s"); 

    $id = null;

    if($req->register == 'Y'){
        
        if($req->collectfee == 'N'){

            $id = SchoolEvents::insertGetId([
                'evname' => $req->name,
                'details' => $req->about,
                'address' => $req->address,
                'date' => $req->date,
                'time' => $req->start_time,
                'register' => $req->register,
                'spaces' => $req->spaces,
                'collectFee' => $req->collectFee,
                'acceptInfo' => $req->acceptInfo,
                'review' => 'Y',
                'imagePath' => $path,
                'created_at' => $date
            ]);

            // $sql="INSERT INTO `tblapp_school_events`(`evname`,`details`,`address`,`time`,`register`,`spaces`,`collectFee`,`acceptInfo`,`review`,`imagePath`)VALUES('$req->name','$req->about','$req->address','$req->time','$req->register','$req->spaces','$req->collectFee','$req->acceptInfo','Y','$path')";
        }

        else{

            $id = SchoolEvents::insertGetId([
                'evname' => $req->name,
                'details' => $req->about,
                'address' => $req->address,
                'date' => $req->date,
                'time' => $req->start_time,
                'register' => $req->register,
                'spaces' => $req->spaces,
                'collectFee' => $req->collectFee,
                'amount' => $req->amount,
                'payinfo' => $req->payinfo,
                'acceptInfo' => $req->acceptInfo,
                'review' => 'Y',
                'imagePath' => $path,
                'created_at' => $date
            ]);

        // $sql="INSERT INTO `tblapp_school_events`(`evname`,`details`,`address`,`time`,`register`,`spaces`,`collectFee`,`amount`,`payinfo`,`acceptInfo`,`review`,`imagePath`)VALUES('$req->name','$req->about','$req->address','$req->time','$req->register','$req->spaces','$req->collectFee','$req->amount','$req->payinfo','$req->acceptInfo','Y','$path')";

        }
    }

    else{

        $id = SchoolEvents::insertGetId([
            'evname' => $req->name,
            'details' => $req->about,
            'address' => $req->address,
            'date' => $req->date,
            'time' => $req->start_time,
            'register' => $req->register,
            'imagePath' => $path,
            'created_at' => $date
        ]);

        // $sql="INSERT INTO `tblapp_school_events`(`evname`,`details`,`address`,`time`,`register`,`imagePath`)VALUES('$req->name','$req->about','$req->address','$req->time','$req->register','$path')";
    }
     
    if($id != null){
        $message = "A new event has been created: \"$req->evname\"";

        $sql="INSERT INTO `tblapp_notifications_general`(`school`,`message`,`eventId`,`time`)VALUES('reg','$message','$id','$date')";

        $rows = DB::insert(DB::raw($sql));
    }

    return response()->json($rows, 200);
}



public function fetchUpcomingEvents(Request $req){
        
    $nowdate = date("Y-m-d"); 

    $sql="SELECT * FROM `tblapp_school_events` WHERE `date` >= '$nowdate' AND `completed` = 'N'";
       
    $rows = DB::select(DB::raw($sql));
     
    $data = [];

    if(count($rows)>0){
    
    foreach($rows as $row){

        $pending = null;
        $accepted = null;

    if($row->register == "Y"){
        $csql = "SELECT count(*) as `pending` FROM `tblapp_events_register` WHERE `eventid` = '$row->id' AND `status` = 'P'";
        $crows = DB::select(DB::raw($csql));
        $pending = $crows[0]->pending;

        $asql = "SELECT count(*) as `accepted` FROM `tblapp_events_register` WHERE `eventid` = '$row->id' AND `status` = 'A'";
        $arows = DB::select(DB::raw($asql));
        $accepted = $arows[0]->accepted;
    }
        array_push($data,array(
            'event'=>$row,
            'pending'=>$pending,
            'accepted'=>$accepted,
            'nowdate' => $nowdate,
        ));
    }
 }
    return response()->json($data, 200);
 }



 public function fetchPastEvents(Request $req){
        
    $nowdate = date("Y-m-d"); 

    $sql="SELECT * FROM `tblapp_school_events` WHERE `date` < '$nowdate' OR `completed` = 'Y'";
       
    $rows = DB::select(DB::raw($sql));
     
    $data = [];

    if(count($rows)>0){
    
    foreach($rows as $row){

        $pending = null;
        $accepted = null;

    if($row->register == "Y"){
        $csql = "SELECT count(*) as `pending` FROM `tblapp_events_register` WHERE `eventid` = '$row->id' AND `status` = 'P'";
        $crows = DB::select(DB::raw($csql));
        $pending = $crows[0]->pending;

        $asql = "SELECT count(*) as `accepted` FROM `tblapp_events_register` WHERE `eventid` = '$row->id' AND `status` = 'A'";
        $arows = DB::select(DB::raw($asql));
        $accepted = $arows[0]->accepted;
    }
        array_push($data,array(
            'event'=>$row,
            'pending'=>$pending,
            'accepted'=>$accepted,
            'nowdate' => $nowdate,
        ));
    }
 }
    return response()->json($data, 200);
 }



public function eventRequestAction(Request $req){
        
    $sql="UPDATE `tblapp_events_register` SET `status` = '$req->status' WHERE `id` = '$req->id'";
       
    $rows = DB::update(DB::raw($sql));

    if($rows = 1){
        if($req->status == "A"){
            $usql = "UPDATE `tblapp_school_events` SET `spaces` = `spaces` - 1 WHERE `id` = '$req->eventId'";

            DB::update(DB::raw($usql));

            $message = "Your request for the event \"$req->evname\" has been accepted.";
        }

        else if($req->status == "Rej"){
            $usql = "UPDATE `tblapp_school_events` SET `spaces` = `spaces` + 1 WHERE `id` = '$req->eventId'";

            DB::update(DB::raw($usql));
            
            $message = "Your request for the event \"$req->evname\" has been rejected because : \"$req->reason\"";
        }

    $time = date("Y-m-d H:i:s");

    $sql="INSERT INTO `tblapp_notifications_student`(`studentid`,`message`,`eventId`,`time`)VALUES('$req->studentid','$message','$req->eventId','$time')";

    $rows = DB::insert(DB::raw($sql));
    
   }       
    return response()->json($rows, 200);
}


public function fetchRequests(Request $req){
        
    $sql="SELECT `tblapp_events_register`.`id`, `tblapp_events_register`.`stuid`, `tblapp_events_register`.`eventid`, `tblapp_events_register`.`reciept`, `firstname`, `lastname`, `proglevel`, `program` FROM `tblapp_events_register`, `r_student` WHERE `tblapp_events_register`.`eventid` = '$req->eventId' AND `tblapp_events_register`.`status` = '$req->status' AND `tblapp_events_register`.`stuid` = `r_student`.`idnumber`";
       
    $rows = DB::select(DB::raw($sql));

    return response()->json($rows, 200);
}

}