<?php


use App\Http\Controllers\AcademicYear;
use App\Http\Controllers\AccesPinController;
use App\Http\Controllers\AppSupportController;
use App\Http\Controllers\AppSupportManagerController;
use App\Http\Controllers\AssignmentsController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BookmarksController;
use App\Http\Controllers\ClubsController;
use App\Http\Controllers\ClubPostsController;
use App\Http\Controllers\DeferSemController;
use App\Http\Controllers\EventsManagerController;
use App\Http\Controllers\TranscriptRequestController;
use App\Http\Controllers\IntroductoryRequestController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\PlatformsManager;
use App\Http\Controllers\ResultPortalController;
use App\Http\Controllers\SchoolEventsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::post('/auth/register', [AuthController::class, 'register']);
// Route::post('/auth/login', [AuthController::class, 'login']);

Route::name('students.')->prefix('student-pr6tux8')->group(function () {

    Route::get('/test', [function () {
        return response()->json(['message' => 'Hello World!'], 200);
    }]);

    Route::post('/student-google-login', [LoginController::class, 'googleLogin']);
    Route::post('/student-lemass-login', [LoginController::class, 'lemassLogin']);


    Route::post('/academicYear', [AcademicYear::class, 'academic_year']);


    Route::post('/ass', [AssignmentsController::class, 'assignments']);
    Route::post('/quiz', [AssignmentsController::class, 'fetch_quiz']);
    Route::post('/midsem', [AssignmentsController::class, 'fetch_midsem']);
    Route::post('/endofsem', [AssignmentsController::class, 'fetch_endofsem']);


    Route::post('/sem-grades', [ResultPortalController::class, 'semesterGrades']);
    Route::post('/sem-completion', [ResultPortalController::class, 'semesterCompletion']);
    Route::post('/courses-uncompleted', [ResultPortalController::class, 'fetchUncompleted']);
    Route::post('/student-cgpa', [ResultPortalController::class, 'fetchCgpa']);
    Route::post('/student-backlog', [ResultPortalController::class, 'fetchBacklog']);


    Route::post('/deferSem', [DeferSemController::class, 'defer']);
    Route::post('/transcriptRequest', [TranscriptRequestController::class, 'request']);
    Route::post('/introductoryLetter', [IntroductoryRequestController::class, 'request']);


    Route::post('/fetchCoursePlatforms', [PlatformsManager::class, 'fetchCoursePlatforms']);
    Route::post('/fetchGeneralPlatforms', [PlatformsManager::class, 'fetchGeneralPlatforms']);
    Route::post('/fetchRegCoursePlatforms', [PlatformsManager::class, 'fetchRegPlatforms']);


    Route::post('/set-access-pin', [AccesPinController::class, 'setPin']);


    Route::get('/fetch-upcoming-events/{stuid}', [SchoolEventsController::class, 'fetchUpcomingEvents']);
    Route::get('/fetch-past-events/{stuid}', [SchoolEventsController::class, 'fetchPastEvents']);
    Route::post('/event/register-event', [SchoolEventsController::class, 'registerforEvent']);


    Route::post('bookmarks/add-bookmark', [BookmarksController::class, 'addBookMark']);
    Route::delete('bookmarks/del-bookmark/{id}', [BookmarksController::class, 'deleteBookMark']);
    Route::get('bookmarks/fetch-bookmarks/{stuid}', [BookmarksController::class, 'fetchBookMarks']);


    //Route::get('/faqs/fetch-faqs', [AppSupportController::class, 'fetchFaqs']);
    Route::get('/upcoming/fetch-upcoming-and-faqs', [AppSupportController::class, 'fetchUpcomingsAndFaqs']);

});

// Route::post('/clubs', [ClubsController::class, 'clubs']);
// Route::post('/clubPosts', [ClubPostsController::class, 'club_posts']);



Route::name('app-manager.')->prefix('app-manager')->group(function () {

    Route::post('/addCourse', [PlatformsManager::class, 'addCoursePlatform']);
    Route::post('/addGeneral', [PlatformsManager::class, 'addGeneralPlatform']);
    Route::post('/fetchCampus', [PlatformsManager::class, 'fetchCampuses']);
    Route::post('/fetchPlatformTypes', [PlatformsManager::class, 'fetchPlatformTypes']);
    Route::post('/fetchCoursePlatforms', [PlatformsManager::class, 'fetchCoursePlatforms']);
    Route::post('/fetchGeneralPlatforms', [PlatformsManager::class, 'fetchGeneralPlatforms']);
    Route::post('/deletePlatforms', [PlatformsManager::class, 'deletePlatforms']);


    Route::post('/create-new-event', [EventsManagerController::class, 'createEvent']);
    Route::get('/fetch-upcoming-events', [EventsManagerController::class, 'fetchUpcomingEvents']);
    Route::get('/fetch-past-events', [EventsManagerController::class, 'fetchPastEvents']);
    Route::get('/event/fetch-requests/{eventId}/{status}', [EventsManagerController::class, 'fetchRequests']);
    Route::post('/event/perform-request-action', [EventsManagerController::class, 'eventRequestAction']);


    Route::post('/upcoming/create-new-upcoming', [AppSupportManagerController::class, 'createUpcoming']);
    Route::get('/upcoming/fetch-upcomings', [AppSupportManagerController::class, 'fetchUpcomings']);
    Route::get('/faqs/fetch-faqs', [AppSupportManagerController::class, 'fetchFaqs']);

});



// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });
