// JavaScript Document
/**
 * 
 */
JA_Contentslide = new Class({
	/**
	 * function initialize
	 */
	initialize: function(params){
		/* */
		this.items 			= params.items;
		/* */
		this.mode 			= params.mode || 'horizontal';
		/* */
		this.size 		    = params.size || 240;
		/* */
		this.box 		    = params.box.setStyle(this.modes[this.mode][1],(this.size*this.items.length)+'px');
		/* */
		this.button_event   = params.button_event || 'click';
		/* */
		this.handle_event   = params.handle_event || 'click';
		/* */
		this.interval 	    = params.interval || 5000;
		/* */
		this.buttons 		= {previous: [], next: [], play: [], playback: [], stop: []};
		/* */
		if( params.buttons ){
			for( var action in params.buttons ){
				this.bindButtonsEvent(action, $type(params.buttons[action])=='array' ? params.buttons[action] : [params.buttons[action]]);
			}
		}
		/* */
		this.handles = params.handles || null;
		if(this.handles){
			this.bindButtonsHandle(this.handles);
		}
		/* */
		this.fx = new Fx.Style(this.box,this.modes[this.mode][0],params.fxOptions||{duration:500,wait:false});
		/* */
		this.onWalk = params.onWalk || null;
		/* */
		this.currentIndex = params.startItem || 0;
		/* */
		this.previousIndex = null;
		/* */
		this.nextIndex = null;
		/* */
		this.autoPlay = params.autoPlay || false;
		/* */
		this._auto = null;
		/* */
		this.box.setStyle(this.modes[this.mode][0],(-this.currentIndex*this.size)+'px');
		/* */
		if(params.autoPlay) this.play( this.interval,'next',true );
		
	},
	/**
	 * function stop
	 */
	 previous: function(manual){
		this.currentIndex += this.currentIndex>0 ? -1 : this.items.length-1;
		this.walk(null,manual);
	 },
	/**
	 * function stop
	 */
	next: function(manual){
		this.currentIndex += this.currentIndex<this.items.length-1 ? 1 : 1-this.items.length;
		this.walk(null,manual);
	},
	/**
	 * function stop
	 */
	play: function(delay,direction,wait){
		this.stop();
		if(!wait){
			this[direction](false);
		}
		this._auto = this[direction].periodical(delay,this,false);
	},
	/**
	 * function stop
	 */
	stop: function(){
		$clear(this._auto);
	},
	/**
	 * function walk
	 */
	 walk: function( item, manual ){
		
		if( $defined(item) ){
			if( item == this.currentIndex ) return;
			
			this.currentIndex=item;
		}
		
		this.previousIndex = this.currentIndex + ( this.currentIndex > 0 ? -1 : this.items.length - 1 );
		this.nextIndex 	   = this.currentIndex + ( this.currentIndex<this.items.length-1 ? 1 : 1-this.items.length );
		
		/* */
		if( manual ){ 
			this.stop(); 
		}
		/* */
		this.fx.start( -this.currentIndex*this.size );
		/* */
		if(this.onWalk){ 
			this.onWalk(this.items[this.currentIndex],(this.handles?this.handles[this.currentIndex]:null) ); 
		}
		/* */
		if (manual && this.autoPlay ){ 
			this.play(this.interval,'next',true); 
		}
	},
	/**
	 * function bindButtonsHandle
	 */
	bindButtonsHandle: function( handles ){
		for(var i=0;i<handles.length;i++){
			handles[i].addEvent( this.handle_event, this.walk.bind(this, [i,true]) );
		}
	},
	/**
	 * function bindButtonsEvent
	 */
	 bindButtonsEvent: function( action, buttons ){
		for( var i = 0; i < buttons.length; i++ ){
			switch( action ){
				case 'previous':
					buttons[i].addEvent( this.button_event, this.previous.bind(this,true) ); 
					break;
				case 'next':
					buttons[i].addEvent( this.button_event, this.next.bind(this,true) ); 
					break;
				case 'play':
					buttons[i].addEvent( this.button_event,this.play.bind(this,[this.interval,'next',false]) );
					break;
				case 'playback': 
					buttons[i].addEvent( this.button_event,this.play.bind(this,[this.interval,'previous',false]) ); 
					break;
				case 'stop': 
					buttons[i].addEvent( this.button_event,this.stop.bind(this) ); 
					break;
			}
			this.buttons[action].push(buttons[i]);
		}
	}
					
});