<?php
/**
 * @package JFusion
 * @author JFusion development team
 * @copyright Copyright (C) 2009 JFusion. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */

class Jfusion_Joomla_Helper_Data extends Mage_Core_Helper_Data {

	protected $_data;

	function __construct() {
		$this->_data = Mage::getStoreConfig ( 'joomla/joomlaconfig' );
	}

	function getBaseURL() {
		$parsedUrl = parse_url($this->_data["baseurl"]);
		if(Mage::app()->getStore()->isCurrentlySecure() && $parsedUrl["scheme"] == 'http'){
			$this->_data ['baseurl'] = 'https'. ltrim($this->_data ['baseurl'], 'http');
		}
		return rtrim($this->_data ['baseurl'], '/') . '/';
	}
	
	function getSecretKey(){
		return $this->_data['secret_key'];
	}
	
	function isCacheActivated(){
		return $this->_data['cache'];
	}
}