<?php
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');
require_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');
if(is_dir(JPATH_SITE.DS.'components'.DS.'com_k2')){
  require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
  require_once (JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');
}
class JVCu3erHelper{
	var $fileConfig;
	var $params;	
	var $cu3erCommon;
	function __construct($params){
		$this->fileConfig = JPATH_BASE.DS."modules".DS."mod_jv_cu3er".DS."assets".DS."config".DS."config.xml";
		$this->params = $params;			
	}
	
	/*
	 * Function create xml config file
	 * @Created by joomvision
	 */	
	function createFileConfig($xml){
		if(is_writeable($this->fileConfig)){
			if(JFile::write($this->fileConfig,$xml)) return true;
			else {
				echo 'Write file error';
			}
		} else {
			echo "Can not write file";
		}
	}
	//End created config file
	
	/*
	 * Function create xml data to write config file
	 * @Created by joomvision
	 */
	function createXMLData(){
		$cu3erCommon = new JVCu3erCommonHelper($this->params);		
		$parentNode = new JSimpleXMLElement('cu3er'); // Create Element - <cu3er>
		// Create Element - <cu3er>.<settings>		
		$nodeChildSetting = &$parentNode->addChild('settings');
		// Create Element - <cu3er>.<settings>.<general>
		$nodeGrandChild = & $this->createGeneral($nodeChildSetting);
		// Create Element - <cu3er>.<settings>.<auto_play>
		if ($this->params->get('enable_auto_play')){
			$nodeGrandChild = & $this->createAutoPlay($nodeChildSetting);
		}
		// Create Element - <cu3er>.<settings>.<pre_button>
		if($this->params->get('enable_prev_button')) {
			$nodeGrandChild = &$this->createPreButton($nodeChildSetting);
		}
		// Create Element - <cu3er>.<settings>.<pre_symbol>
		if($this->params->get('enable_prev_symbol')){
			$nodeGrandChild = &$this->createPreviousSymbol($nodeChildSetting);
		}
		// Create Element - <cu3er>.<settings>.<next_button>
		if ($this->params->get('enable_next_button')){
			$nodeGrandChild = &$this->createNextButton($nodeChildSetting);
		}
		// Create Element - <cu3er>.<settings>.<next_symbol>
		if($this->params->get('enable_next_symbol')){
			$nodeGrandChild = &$this->createNextSymbol($nodeChildSetting);
		}
		// Create Element - <cu3er>.<settings>.<preloader>
		if ($this->params->get('enable_preloader')){
			$nodeGrandChild =&$this->createPreload($nodeChildSetting);
		}
		// Create Element - <cu3er>.<settings>.<description>
		if ($this->params->get('enable_description_box')){
			$nodeGrandChild = & $this->createDescriptionBox($nodeChildSetting);
		}
	
		// Create Element - <cu3er>.<slides>
		$nodeGrandChild = & $this->createSlides($parentNode);
		$string = '<?xml version="1.0" encoding="utf-8"?>';
		$string .= $parentNode->toString(true);
		return $string;
		//var_dump($parentNode->toString());
		
	}
	//End create xml data
	
	/*
	 * Function create slides
	 * @Created by joomvision
	 */
	function createSlides(&$node){
		$cu3erCommon = new JVCu3erCommonHelper($this->params);
		$results = $cu3erCommon->getItemsByContent();
		$nodeChild = $node->addChild('Slides');
		for($i=0;$i<count($results);$i++){
			$nodeGrandChild = $this->createSlide($nodeChild,$results,$i);
			$nodeGrandChild = $this->createTransition($nodeChild,$results,$i);
		}
	}	
	//End create slides
	function createSlide(&$node,$slides,$position){
		$nodeGrandChild = $node->addChild('slide');	
		$url = $slides[$position]->thumb;
		$nodeL1 =& $nodeGrandChild->addChild('url');
		$nodeL1->setData($url);//Url to image
		$link = $slides[$position]->link;
		$nodeL1 =& $nodeGrandChild->addChild('link');
		$nodeL1->setData($link);//Link
		$title = $slides[$position]->title;
		$nodeL1 =& $nodeGrandChild->addChild('description');
		$nodeL2 =& $nodeL1->addChild('heading');	
		$nodeL2->setData($title);//
		$nodeL2 = &$nodeL1->addChild('paragraph');
		$des = $slides[$position]->introtext;
		$nodeL2->setData($des);
		return $node;	
	}
	function createTransition($nodeChild,$results,$position){
		$nodeL1 = $nodeChild->addChild('transition');
		$attbs = array("num", "slicing", "direction", "duration", "delay", "shader", "light_position", "cube_color", "z_multiplier");
		$found = false;
		foreach($attbs as $value){
			$param = $this->params->get('transition_'.$value);
			$str = $this->getParam($param,$position+1);
			if(strlen($str)){
				$found = true;
				$nodeL1->addAttribute($value, $str);
			}
		}
		// Remove Child if have no attributes
		if (!$found) $nodeChild->removeChild($nodeL1);
		return $nodeChild;
	}
	
	/*
	 * Function create general setting in cu3er
	 * @Created by joomvision
	 */
	function createGeneral(&$node){
		$general = array();
		$general['slide_panel_width'] = (int) $this->params->get('slide_panel_width');
		$general['slide_panel_height'] = (int) $this->params->get('slide_panel_height');
		$general['slide_panel_horizontal_align'] = (string) $this->params->get('slide_panel_horizontal_align');
		$general['slide_panel_vertical_align'] = (string)$this->params->get('slide_panel_vertical_align');
		$general['ui_visibility_time'] = (int)$this->params->get('ui_visibility_time'); 
		// Create Element - <cu3er>.<settings>.<general>
		$nodeChild = & $node->addChild('general');
		// Create Attributes of <cu3er>.<settings>.<general>
		$this->addAttributes($nodeChild,$general);
		return $node;			
	}
	//End create general setting
	
	/*
	 * Function create auto play setting in cu3er
	 * @Created by joomvision
	 */
	function createAutoPlay(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = 'auto_play';
		$attributes = array();
		$attributes["defaults"]  = array( "symbol"	=> $this->params->get('auto_play_symbol', 'linear'), 
							"time"		=> $this->params->get('auto_play_time_defaults', 5));
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<auto_play>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);				
		return $node;
	}
	//End create auto play
	
	/*
	 * Function create pre button
	 * @Created by joomvision
	 */
	function createPreButton(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = "prev_button";
		$attributes = array();
		$attributes["defaults"]  = array( "round_corners"	=> $this->params->get('prev_button_round_corners', '0, 0, 0, 0'));
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<pre_button>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);
		return $node;
	}
	//End
	function createPreviousSymbol(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = 'prev_symbol';
		$attributes = array();
		$attributes["defaults"]  = array( "type" => $this->params->get('prev_symbol_type', '1'));
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<prev_symbol>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);
		return $node;
	}
	
	function createNextButton(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = 'next_button';
		$attributes = array();
		$attributes["defaults "]  = array( "round_corners" => $this->params->get('next_button_round_corners', '0, 0, 0, 0'));
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<next_button>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);
		return $node;
	}
	function createNextSymbol(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = 'next_symbol';
		$attributes = array();
		$attributes["defaults"]  = array( "type" => $this->params->get('next_symbol_type', '1'));
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<next_symbol>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);
		return $node;
	}
	function createPreload(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = 'preloader';
		$attributes = array();
		$attributes["defaults"]  = array( "symbol" => $this->params->get('preloader_symbol', 'linear'));
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<preload>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);
		return $node;
	}
	function createDescriptionBox(&$node){
		$childName = array("defaults", "tweenIn", "tweenOut", "tweenOver");
		$name = 'description';
		$attributes = array();
		$attributes["defaults"]  = array(
				"round_corners" 				=> $this->params->get('description_round_corners', '0, 0, 0, 0'),
				"heading_font" 					=> $this->params->get('description_heading_font', 'Georgia'),
				"heading_text_size" 			=> $this->params->get('description_heading_text_size', '18'),
				"heading_text_color" 			=> $this->params->get('description_heading_text_color', '0x000000'),
				"heading_text_align" 			=> $this->params->get('description_heading_text_align', 'left'),
				"heading_text_margin" 			=> $this->params->get('description_heading_text_margin', '10, 25, 0, 25'),
				"heading_text_leading" 			=> $this->params->get('description_heading_text_leading', '0'),
				"heading_text_letterSpacing"	=> $this->params->get('description_heading_text_letterSpacing', '0'),
				"paragraph_font" 				=> $this->params->get('description_paragraph_font', 'Arial'),
				"paragraph_text_size" 			=> $this->params->get('description_paragraph_text_size', '12'),
				"paragraph_text_color" 			=> $this->params->get('description_paragraph_text_color', '0x000000'),
				"paragraph_text_align" 			=> $this->params->get('description_paragraph_text_align', 'left'),
				"paragraph_text_margin" 		=> $this->params->get('description_paragraph_text_margin', '5, 25, 0, 25'),
				"paragraph_text_leading" 		=> $this->params->get('description_paragraph_text_leading', '0'),
				"paragraph_text_letterSpacing" 	=> $this->params->get('description_paragraph_text_letterSpacing', '0')
		);
		$attributes['tweenIn'] = $this->getTweenData('in',$name);
		$attributes['tweenOut'] = $this->getTweenData('out',$name);
		$attributes['tweenOver'] = $this->getTweenData('over',$name);
		// Create Element - <cu3er>.<settings>.<description>
		$nodeChild = $this->constructElement($node,$name,$childName,$attributes);
		return $node;
	}
	
	function constructElement(&$node,$name,$childName,$attributes){
		if(empty($name)) return;
		$nodeChild = &$node->addChild($name);
		foreach($childName as $key=>$value){
			if(!empty($value)){
			 $nodeGrandChild = &$nodeChild->addChild($value);
			 if(array_key_exists($value,$attributes)){
			 	$attr = $attributes[$value];
			 	if(isset($attr)) $this->addAttributes($nodeGrandChild,$attr);
			 }
			}			 
		}
		return $node;
	}
	
	/*
	 * Function add attributes of element 
	 * @Created by joomvision
	 */
	function addAttributes(&$node,$attributes){
		if(empty($attributes)) return;		
		foreach($attributes as $key => $value){
			if(trim($value) != '') $node->addAttribute($key,$value);
		}
		return $node;
	}
	//End add attributes of element
	
	
	/*
	 * Function get param in a String Parameter are seperated with vertical bar symbol (|).
	 * @Created by jooomvision
	 */
	function getParam($param,$position){
		$str = '';
		$aryParams = explode('|',$param);
		if(count($aryParams) <  $position) return $str;
		else {
			$str = trim($aryParams[$position-1]);
			if(!strlen($str)) return '';
		}
		return $str;
	}
	//End get param in string parameter
	
	/*
	 * Function get tween data
	 * @Created by joomvision
	 */
	function getTweenData($type,$name){
		$tween = array();
		$keys = array("time", "delay", "x", "y", "width", "height", "rotation", "alpha", "tint", "scaleX", "scaleY");
		foreach($keys as $key){
			$tween[$key] = $this->getTween($this->params->get($name.'_'.$key),$type);
		}
		return $tween;
	}
	//End get tween data
	function getTween($param,$type){
		$type = strtolower($type);
		$str = '';
		switch ($type){
			case "in":
				$str = $this->getParam($param,1);
				break;
			case "out":
				$str = $this->getParam($param,2);
				break;
			case "over":
				$str = $this->getParam($param,3);
				break;				
		}
		return $str;		
	}	
}
class JVCu3erCommonHelper{
	var $params;
	function __construct($params){
		$this->params = $params;
		$this->createdDirThumb();
		$this->createdDirThumb('externallink');
	}
	function createdDirThumb($comp='com_content',$folderImage=''){
		$thumbImgParentFolder = JPATH_BASE.DS.'images'.DS.'stories'.DS.'thumbs'.DS.$comp.$folderImage;
		if(!JFolder::exists($thumbImgParentFolder)){
			JFolder::create($thumbImgParentFolder);
		}
	}
	function getImageSizes($file) {
		return getimagesize($file);
	}
	function checkImage($file) {
		preg_match("/\<img.+?src=\"(.+?)\".+?\/>/", $file, $matches);		
		if(count($matches)){
			return $matches[1];
		} else {return '';}
	}
	function FileExists($file) {
		if(file_exists($file))
		return true;
		else
		return false;
	}
	function getItemsByContent(){
		global $mainframe;
		$db         =& JFactory::getDBO();
		$user       =& JFactory::getUser();
		$userId     = (int) $user->get('id');
		$categories = ( array )$this->params->get('categories',array());
		if(count($categories)){
			$strCatId = implode(',',$categories);
			$categoriesCondi = " AND cc.id IN ($strCatId)";
		}
		$intro_length = intval($this->params->get( 'intro_length', 50));		
		$count = $this->params->get('no_items');
		$aid        = $user->get('aid', 0);
		//Init width and height of thumbnail		
		$thumbWidth = $this->params->get('slide_panel_width');
		$thumbHeight = $this->params->get('slide_panel_height');
		$contentConfig = &JComponentHelper::getParams( 'com_content' );
		$access     = !$contentConfig->get('shownoauth');
		$nullDate   = $db->getNullDate();
		$date =& JFactory::getDate();
		$now = $date->toMySQL();
		$where      = 'a.state = 1'
		. ' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )'
		. ' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )';
		// Ordering		
		$orderBy = $this->params->get('ordering');
		$ordering = 'a.'.$orderBy.' '.$this->params->get('sort_order');	
		// Content Items only
		$query = 'SELECT a.*,a.id as key1, cc.id as key2, cc.title as cat_title, ' .
            ' CASE WHEN CHAR_LENGTH(a.alias) THEN CONCAT_WS(":", a.id, a.alias) ELSE a.id END as slug,'.
            ' CASE WHEN CHAR_LENGTH(cc.alias) THEN CONCAT_WS(":", cc.id, cc.alias) ELSE cc.id END as catslug'.
            ' FROM #__content AS a' .             
            ' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
            ' INNER JOIN #__sections AS s ON s.id = a.sectionid' .
            ' WHERE '. $where .' AND s.id > 0' .
		($access ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
		(count($categories) ? $categoriesCondi:'').
            ' AND s.published = 1' .
            ' AND cc.published = 1' .
            ' ORDER BY '. $ordering;	
		$db->setQuery($query, 0, $count);
		$rows = $db->loadObjectList();		
		if(count($rows)){
		$i      = 0;
		$lists  = array();
		$article_count = count($rows);		
		foreach ( $rows as $row ){
			$imageurl = $this->checkImage($row->introtext);
			$folderImg = DS.$row->id;
			$lists[$i]->thumb_diff = '';
			$lists[$i]->thumb = '';
			$this->createdDirThumb('com_content',$folderImg);			
			$lists[$i]->title = $row->title;
			$lists[$i]->alias = $row->alias;
			$lists[$i]->link = JRoute::_(ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid));
			$lists[$i]->introtext = $this->introContent($row->introtext, $intro_length,'');					
			if($this->checkImage($row->introtext)) $lists[$i]->thumb = $this->getThumb($row->introtext,$thumbWidth,$thumbHeight,false,$row->id,'com_content');
			$i++;			
		}		
		}
		return $lists;
	}
	/*
	 * Function create thumbnail of image in content
	 * @Created by joomvision
	 */
	function getThumb($text, $tWidth,$tHeight, $reflections=false,$id=0,$isComp='com_content'){
		preg_match("/\<img.+?src=\"(.+?)\".+?\/>/", $text, $matches);
		$paths = array();
		$showbug = true;
		if (isset($matches[1])) {
			$image_path = $matches[1];
			//joomla 1.5 only		
			$isInternalLink = $this->isInternalLink($image_path);
			if(!$isInternalLink) {
				$path_parts = pathinfo($image_path);
				$imgName = $path_parts['basename'];													
				$internalLink = JPATH_BASE.DS."images".DS."stories".DS."thumbs".DS."externallink".DS.$imgName;
				$this->saveImage($internalLink,$image_path);
				$image_path = "images/stories/thumbs/externallink/".$imgName;
			} else {
				if(!$this->FileExists($image_path)) return '';
			}
			// create a thumb filename
			$file_div = strrpos($image_path,'.');
			$thumb_ext = substr($image_path, $file_div);
			$thumb_prev = substr($image_path, 0, $file_div);
			$thumb_path = '';
			$thumb_path = 'images/stories/thumbs/'.$isComp.'/'.$id.'/jvcu3er_'.$tWidth.'x'.$tHeight.$thumb_ext;
			if(file_exists($thumb_path)) @unlink($thumb_path);
			// check to see if this file exists, if so we don't need to create it			
			if ($thumb_path !='' && function_exists("gd_info") && !file_exists($thumb_path)) {
				// file doens't exist, so create it and save it
				include_once('thumbnail.inc.php');
				$thumb = new JVThumbnail($image_path);
				if ($thumb->error) {
					if ($showbug)   echo "JV Image ERROR: " . $thumb->errmsg . ": " . $image_path;
					return false;
				}
				//$thumb->resize($size);
				$thumb->resize_image($tWidth,$tHeight);
				if ($reflections) {
					$thumb->createReflection(30,30,60,false);
				}
				if (!is_writable(dirname($thumb_path))) {
					$thumb->destruct();
					return false;
				}
				$thumb->save($thumb_path);
				$thumb->destruct();
			}
			return ($thumb_path);
		} else {
			return false;
		}
	}
	//End create thumbnail
	/*
	 * Function check image is internal link or external link
	 * @Created by joomvision
	 */
	function isInternalLink($image_path){
		$full_url = JURI::base();
		//remove any protocol/site info from the image path
		$parsed_url = parse_url($full_url);
		$paths[] = $full_url;
		if (isset($parsed_url['path']) && $parsed_url['path'] != "/") $paths[] = $parsed_url['path'];
		foreach ($paths as $path) {
			if (strpos($image_path,$path) !== false) {
				$image_path = substr($image_path,strpos($image_path, $path)+strlen($path));
			}
		}			
		// remove any / that begins the path
		if (substr($image_path, 0 , 1) == '/') $image_path = substr($image_path, 1);
		//if after removing the uri, still has protocol then the image
		//is remote and we don't support thumbs for external images
		if (strpos($image_path,'http://') !== false || strpos($image_path,'https://') !== false) { 
			return false;
		} 
		return true;
			
	}
	//End check image

	/*
	 * Function save image from external link in our server
	 * @Created by joomvision
	 */
	function saveImage($inPath,$outPath){ //Download images from remote server		
	   	$ch = curl_init($outPath);
		$fp = fopen($inPath, 'wb');
		curl_setopt($ch, CURLOPT_FILE, $fp);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_exec($ch);
		curl_close($ch);
		fclose($fp);
	}
	//End save image
	
	/*
	 * Function get intro content
	 * @Created by joomvision
	 */
	function introContent($str, $limit = 100,$end_char = '&#8230;'){
		if (trim($str) == '') return $str;
		// always strip tags for text
		$str = strip_tags($str);
		preg_match('/\s*(?:\S*\s*){'.(int)$limit.'}/', $str, $matches);		
		if (strlen($matches[0]) == strlen($str))$end_char = '';
		return rtrim($matches[0]).$end_char;
	}
	//End get intro		
}

?>