<?php

 /**
 * This is the activity module helper file
 *
 * PHP version 5
 *
 * @category   JFusion
 * @package    Modules
 * @subpackage Activity
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * This is the activity module helper file
 *
 * @category   JFusion
 * @package    Modules
 * @subpackage Activity
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */
class modjfusionActivityHelper
{

    /**
     * render a plugin
     *
     * @param string $jname  name of element
     * @param string $config value of element
     * @param string $params node of element
     *
     * @return string html
     */
    function renderPluginAuto($jname, $config, $params)
    {
        //now check to see if the plugin is configured
        $jdb = & JFactory::getDBO();
        $query = 'SELECT status from #__jfusion WHERE name = ' . $jdb->Quote($jname);
        $jdb->setQuery($query);
        $config['selected_forums'] = $params->get('selected_forums_' . $jname);
        if ($jdb->loadResult() == 1) {
            $forum = & JFusionFactory::getForum($jname);
            $public = & JFusionFactory::getPublic($jname);
            $db = & JFusionFactory::getDatabase($jname);
            if (JError::isError($db)) {
                return JText::_('NO_DATABASE');
            } else {
                if ($config['forum_mode'] == 0 || empty($config['selected_forums'])) {
                    $selectedforumssql = "";
                } else if (is_array($config['selected_forums'])) {
                    $selectedforumssql = implode(",", $config['selected_forums']);
                } else {
                    $selectedforumssql = $config['selected_forums'];
                }
                //define some other JFusion specific parameters
                $query = $forum->getActivityQuery($selectedforumssql, $config['result_order'], $config['result_limit']);
                // load
                if ($config['mode'] == LAT) {
                    $db->setQuery($query[$config['mode'] . $config['lat_mode']]);
                } else {
                    $db->setQuery($query[$config['mode']]);
                }
                $result = $db->loadObjectList();
                if ($config['debug']) {
                    $resultBeforeFiltering = $result;
                }
                if (!empty($result)) {
                    $forum->filterActivityResults($result, $config['result_limit']);
                }
                //reorder the keys for the for loop
                if (is_array($result)) {
                    $result = array_values($result);
                }
                if ($config['debug']) {
                    $queryMode = ($config['mode'] == LAT) ? $config['mode'] . $config['lat_mode'] : $config['mode'];
                    $debug = 'Query mode: ' . $queryMode . '<br><br>';
                    $sqlQuery = ($config['mode'] == LAT) ? $query[$config['mode'] . $config['lat_mode']] : $query[$config['mode']];
                    $debug.= 'SQL Query: ' . $sqlQuery . '<br><br>';
                    $debug.= 'Error: ' . $db->stderr() . '<br><br>';
                    $debug.= "Results Before Filtering:<br><pre>" . print_r($resultBeforeFiltering, true) . '</pre><br><br>';
                    $debug.= "Results After Filtering:<br><pre>" . print_r($result, true) . '</pre><br><br>';
                    die($debug);
                } else {
                    // fire
                    if (JError::isError($db)) {
                        return $db->stderr();
                    } else if (!$result) {
                        return JText::_('NO_POSTS');
                    } else {
                        $output = "<ul>";
                        // process result
                        for ($i = 0;$i < count($result);$i++) {
                            $user = "";
                            //get the Joomla userid
                            $userlookup = JFusionFunction::lookupUser($jname, $result[$i]->userid, false, $result[$i]->username);
                            //get the avatar of the logged in user
                            if ($config['avatar']) {
                                // retrieve avatar
                                $avatarSrc = & $config['avatar_software'];
                                if ($jname != 'joomla_int' && $jname != 'joomla_ext' && ($avatarSrc == '' || $avatarSrc == 'jfusion')) {
                                    $avatarImg = $forum->getAvatar($result[$i]->userid);
                                } elseif (!empty($avatarSrc) && $avatarSrc != 'jfusion' && !empty($userlookup)) {
                                    $avatarImg = JFusionFunction::getAltAvatar($avatarSrc, $userlookup->id);
                                }
                                if (empty($avatarImg)) {
                                    $avatarImg = JFusionFunction::getJoomlaURL() . 'components/com_jfusion/images/noavatar.png';
                                }

                                $maxheight = & $config['avatar_height'];
                                $maxwidth = & $config['avatar_width'];
                                $avatar = "<img style='vertical-align:middle; float:left; margin:3px;";
                                $avatar.= (!empty($maxheight)) ? " max-height: {$maxheight}px;" : "";
                                $avatar.= (!empty($maxwidth)) ? " max-width: {$maxwidth}px;" : "";
                                $avatar.= "' src='$avatarImg' alt='avatar' />";
                            } else {
                                $avatar = '';
                            }
                            //process user info
                            if ($config['showuser']) {
                                $displayname = ($config['display_name'] && !empty($result[$i]->name)) ? $result[$i]->name : $result[$i]->username;
                                if ($config['userlink'] && empty($result[$i]->guest)) {
                                    if ($config['userlink_software'] != '' && $config['userlink_software'] != 'jfusion' && $config["userlink_software"] != 'custom' && !empty($userlookup)) {
                                        $user_url = JFusionFunction::getAltProfileURL($config['userlink_software'], $userlookup->id);
                                    } elseif ($config['userlink_software'] == 'custom' && !empty($config['userlink_custom']) && !empty($userlookup)) {
                                        $user_url = $config['userlink_custom'] . $userlookup->id;
                                    } else {
                                        $user_url = false;
                                    }
                                    if ($user_url === false) {
                                        $user_url = JFusionFunction::routeURL($forum->getProfileURL($result[$i]->userid, $result[$i]->username), $config['itemid']);
                                    }
                                    $user = '<a href="' . $user_url . '" target="' . $config['new_window'] . '">' . $displayname . '</a>';
                                } elseif (!empty($result[$i]->guest)) {
                                    $user = $displayname . " (" . JText::_('GUEST') . ")";
                                } else {
                                    $user = $displayname;
                                }
                                $user = " - <b>" . $user . "</b> ";
                            }
                            //process date info
                            if ($config['showdate']) {
                                jimport('joomla.utilities.date');
                                $JDate = new JDate($result[$i]->dateline);
                                $JDate->setOffset($config['tz_offset']);
                                $date = $JDate->toFormat($config['date_format']);
                            } else {
                                $date = '';
                            }
                            //process subject or body info
                            $subject = (($config['replace_subject'] == 0 && empty($result[$i]->subject)) || $config['replace_subject'] == 1) ? $result[$i]->body : $result[$i]->subject;
                            //make sure that a message is always shown
                            if (empty($subject)) {
                                $subject = JText::_('NO_SUBJECT');
                            } elseif (!empty($config['character_limit_subject']) && JString::strlen($subject) > $config['character_limit_subject']) {
                                //we need to shorten the subject
                                $subject = JString::substr($subject, 0, $config['character_limit_subject']) . '...';
                            }
                            //combine all info into an urlstring
                            if ($config['linktype'] == LINKPOST) {
                                $urlstring_pre = JFusionFunction::routeURL($forum->getPostURL($result[$i]->threadid, $result[$i]->postid), $config['itemid']);
                                $urlstring = '<a href="' . $urlstring_pre . '" target="' . $config['new_window'] . '">' . $subject . '</a>';
                            } else {
                                $urlstring_pre = JFusionFunction::routeURL($forum->getThreadURL($result[$i]->threadid), $config['itemid']);
                                $urlstring = '<a href="' . $urlstring_pre . '" target="' . $config['new_window'] . '">' . $subject . '</a>';
                            }
                            if ($config['mode'] == LAT) {
                                if ($config['show_reply_num']) {
                                    $existingthread = $forum->getThread($result[$i]->threadid);
                                    $count = (!empty($existingthread)) ? $forum->getReplyCount($existingthread) : 0;
                                    $post = ($count == 1) ? "REPLY" : "REPLIES";
                                    $body = " [$count " . JText::_($post) . "]";
                                } else {
                                    $body = "";
                                }
                            } else {
                                //gotta make it presentable
                                if ($config['display_body'] == 1) {
                                    $body = $result[$i]->body;
                                    $status = $public->prepareText($body, 'activity', $params, $result[$i]);
                                    if (!empty($config['character_limit']) && empty($status['limit_applied']) && JString::strlen($body) > $config['character_limit']) {
                                        $body = JString::substr($body, 0, $config['character_limit']) . '...';
                                    }
                                } else {
                                    $body = "";
                                }
                            }
                            //put it all together for output
                            //prevents the images from cascading
                            $liStyle = (!empty($avatar)) ? ' style="clear:left;"' : '';
                            if ($config['shownew'] && $forum->checkReadStatus($result[$i])) {
                                $newicon = '<img src="' . JFusionFunction::getJoomlaURL() . 'components/com_jfusion/images/new.png" style="margin-left:2px; margin-right:2px;"/>';
                            } else {
                                $newicon = '';
                            }
                            $output.= '<li' . $liStyle . '>' . $avatar . '<i>' . $urlstring . '</i>';
                            if ($newicon) {
                                $output .= " $newicon";
                            }
                            if ($user) {
                                $output .= ' <b>' . $user . '</b>';
                            }
                            if ($date) {
                                $output .= " $date";
                            }
                            if ($body) {
                                $output .= " - $body";
                            }
                            $output .= '</li>';
                        }
                        $output.= "</ul>";
                        return $output;
                    }
                }
            }
        } else {
            return JText::_('NOT_CONFIGURED');
        }
    }

    /**
     * render a plugin mode
     *
     * @param string $jname       name of element
     * @param string $config      value of element
     * @param string $view        value of element
     * @param string $pluginParam node of element
     *
     * @return string html
     */
    function renderPluginMode($jname, $config, $view, $pluginParam)
    {
        $forum = & JFusionFactory::getForum($jname);
        if (method_exists($forum, "renderActivityModule")) {
            return $forum->renderActivityModule($config, $view, $pluginParam);
        }
        return JText::_('NOT_IMPLEMENTED_YET');
    }
}