<?php

/**
 *
 * PHP version 5
 *
 * @category   JFusion
 * @package    JFusionPlugins
 * @subpackage vBulletin
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * JFusion Helper Class for vBulletin
 *
 * @category   JFusion
 * @package    JFusionPlugins
 * @subpackage vBulletin
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */
class JFusionHelper_vbulletin
{
    var $vb_data;
    var $backup;

    /**
     *
     * @return unknown_type
     */
    function JFusionHelper_vbulletin()
    {
        $this->params = & JFusionFactory::getParams($this->getJname());
    }

    /**
     * Returns the name for this plugin
     *
     * @return string
     */
    function getJname()
    {
        return 'vbulletin';
    }

    /**
     * Initializes the vBulletin framework
     *
     * @return boolean true on successful initialization
     */
    function vBulletinInit()
    {
        //only initialize the vb framework if it has not already been done
        if (!defined('VB_AREA')) {
            //load the vbulletin framework
            define('VB_AREA', 'JFusion');
            define('VB_ENTRY', 'JFusion');
            define('THIS_SCRIPT', 'JFusion');
            define('SKIP_SESSIONCREATE', 1);
            define('DIE_QUIETLY', 1);
            define('SKIP_USERINFO', 1);
            define('NOPMPOPUP', 1);
            define('CWD', $this->params->get('source_path'));

            $phrasegroups = array('postbit');
            $specialtemplates = array();
            $globaltemplates = array(
                'bbcode_code_printable',
                'bbcode_html_printable',
                'bbcode_php_printable',
                'bbcode_quote_printable',
                'postbit_attachment',
                'postbit_attachmentimage',
                'postbit_attachmentthumbnail',
                'postbit_external',
            );
            $actiontemplates = array();
            global $vbulletin;
            if (file_exists(CWD)) {
                require_once CWD . '/includes/init.php';
                $this->vb_data  = $vbulletin;
                //force into global scope
                $GLOBALS["vbulletin"] = $vbulletin;
                $vbulletin->db->query_first("USE " . $this->params->get('database_name'));
                $GLOBALS["db"] = $vbulletin->db;
            } else {
                JError::raiseWarning(500, JText::_('SOURCE_PATH_NOT_FOUND'));
                return false;
            }
        } elseif (defined('VB_AREA') && VB_AREA == 'JFusion') {
            $this->vb_data->db->query_first("USE " . $this->params->get('database_name'));
            if (empty($GLOBALS['vbulletin'])) {
                $GLOBALS['vbulletin'] = $this->vb_data;
            }
            if (empty($GLOBALS['db'])) {
                $GLOBALS['db'] = $this->vb_data->db;
            }
        } elseif (defined('VB_AREA')) {
           //vb is calling up JFusion so load the $vbulletin global
           global $vbulletin;
           if (!empty($vbulletin)) {
               $this->vb_data = $vbulletin;
           } else {
               //these is for sure going to lead to something bad so let's die now
               die('vB JFusion Integration Fatal Error - Please contact the site administrator!');
           }
        } else {
            return false;
        }
        return true;
    }

    /**
     * Convert the existinguser variable into something vbulletin understands
     *
     * @param $existinguser object with existing vb userinfo
     *
     * @return array
     */
    function convertUserData($existinguser)
    {
        $userinfo = array('userid' => $existinguser->userid, 'username' => $existinguser->username, 'email' => $existinguser->email, 'password' => $existinguser->password);
        return $userinfo;
    }

    /**
     * Backs up Joomla's various Joomla variables before calling vBulletin's data managers
     */
    function backupJoomla()
    {
        $this->backup['globals'] = $GLOBALS;
        //let's take special precautions for Itemid
        $this->backup['itemid'] = JRequest::getInt('Itemid', 0);
    }

    /**
     * Restores Joomla's various Joomla variables after calling vBulletin's data managers
     */
    function restoreJoomla()
    {
        //restore Joomla's autoload function
        spl_autoload_register('__autoload');

        if (isset($this->backup['globals'])) {
            $GLOBALS = $this->backup['globals'];
        }
        if (isset($this->backup['itemid'])) {
            JRequest::setVar('Itemid', $this->backup['itemid']);
            global $Itemid;
            $Itemid = $this->backup['itemid'];
        }
        $this->backup = array();
        //make sure Joomla's db object is still connected
        JFusionFunction::reconnectJoomlaDb();
    }

    /**
     * Obtains the version of the integrated vbulletin
     *
     * @return string Version number
     */
    function getVersion()
    {
        static $jfusion_vb_version;
        if(empty($jfusion_vb_version)) {
            $db =& JFusionFactory::getDatabase($this->getJname());
            $q = "SELECT value FROM #__setting WHERE varname = 'templateversion'";
            $db->setQuery($q);
            $jfusion_vb_version = $db->loadResult();
        }
        return $jfusion_vb_version;
    }

    /*
     * Creates a basic vB SEF url for vB 4
     *
     * @param (array) $uri  Array with uri pieces
     * @param (string) $type Type of url eg. forum, thread, member
     *
     * @return string $url  Appropriate URL
     */
    function getVbURL($url, $type = false)
    {
        $params = & JFusionFactory::getParams($this->getJname());
        $allow_sef = $params->get("allow_sef", 1);
        $vbversion = & $this->getVersion();
        if (!empty($allow_sef) && (int) substr($vbversion, 0, 1) > 3) {
            $db = & JFusionFactory::getDatabase($this->getJname());

            if (!defined('JFVB_FRIENDLYURL')) {
                $query = "SELECT value FROM #__setting WHERE varname = 'friendlyurl'";
                $db->setQuery($query);
                $sefmode = $db->loadResult();
                define('JFVB_FRIENDLYURL', (int) $sefmode);
            }

            $uri = new JURI($url);

            switch ($type) {
                case 'members':
                    $query = 'SELECT username FROM #__user WHERE userid = ' . $uri->getVar('u');
                    $db->setQuery($query);
                    $username = $db->loadResult();
                    $this->cleanForVbURL($username);
                    $vburi = $uri->getVar('u') . '-' . $username;
                    break;
                case 'threads':
                    $query = 'SELECT title FROM #__thread WHERE threadid = ' . $uri->getVar('t');
                    $db->setQuery($query);
                    $title = $db->loadResult();
                    $this->cleanForVbURL($title);
                    $vburi = $uri->getVar('t') . '-' . $title;
                    break;
                case 'post':
                    $pid = $uri->getVar('p');
                    $tid = $uri->getVar('t');

                    if (empty($tid)) {
                        $query = 'SELECT threadid FROM #__post WHERE postid = ' . $pid;
                        $db->setQuery($query);
                        $tid = $db->loadResult();
                        $query = 'SELECT title FROM #__thread WHERE threadid = ' . $tid;
                        $db->setQuery($query);
                        $title = $db->loadResult();
                        $this->cleanForVbURL($title);
                    }

                    $vburi = $tid . '-' . $title;
                    $uri->setVar('viewfull', 1);
                    $type = 'threads';
                    break;
                case 'forums':
                default:
                    //bad type so return url unaltered
                    return $url;
                    break;
            }

            $query = $uri->getQuery();
            $fragment = $uri->getFragment();
            if ($fragment) {
                $fragment = '#' . $fragment;
            }

            switch (JFVB_FRIENDLYURL) {
                case 1:
                    $sef_url = $uri->getPath() . '?' . $vburi . ($query ? '&' . $query : '') . $fragment;
                    break;
                case 2:
                    $sef_url = $uri->getPath() . '/' . $vburi . ($query ? '?' . $query : '') . $fragment;
                    break;
                case 3:
                    $sef_url = $type . '/' . $vburi . ($query ? '?' . $query : '') . $fragment;
                    break;
                case 0:
                default:
                    $sef_url = $url;
                    break;
            }

            return $sef_url;

        } else {
            return $url;
        }
    }

    /**
     * Prepares text for a vB SEF URL
     *
     * @param &$string text to be cleaned
     */
    function cleanForVbURL(&$string)
    {
        $string = preg_replace('*([\s$+,/:=\?@"\'<>%{}|\\^~[\]`\r\n\t\x00-\x1f\x7f]|(?(?<!&)#|#(?![0-9]+;))|&(?!#[0-9]+;)|(?<!&#\d|&#\d{2}|&#\d{3}|&#\d{4}|&#\d{5});)*s', '-', strip_tags($string));
        $string = trim(preg_replace('#-+#', '-', $string), '-');
    }
}