<?php

/**
 * Abstract forum file
 *
 * PHP version 5
 *
 * @category  JFusion
 * @package   Models
 * @author    JFusion Team <webmaster@jfusion.org>
 * @copyright 2008 JFusion. All rights reserved.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link      http://www.jfusion.org
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Abstract interface for all JFusion forum implementations.
 *
 * @category  JFusion
 * @package   Models
 * @author    JFusion Team <webmaster@jfusion.org>
 * @copyright 2008 JFusion. All rights reserved.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link      http://www.jfusion.org
 */
class JFusionForum
{
    /**
     * returns the name of this JFusion plugin
     *
     * @return string name of current JFusion plugin
     */
    function getJname()
    {
        return '';
    }

    /**
     * Returns the URL to a thread of the integrated software
     *
     * @param int $threadid threadid
     *
     * @return string URL
     */
    function getThreadURL($threadid)
    {
        return '';
    }

    /**
     * Returns the URL to a post of the integrated software
     *
     * @param int $threadid threadid
     * @param int $postid   postid
     *
     * @return string URL
     */
    function getPostURL($threadid, $postid)
    {
        return '';
    }

    /**
     * Returns the URL to a userprofile of the integrated software
     *
     * @param int $uid userid
     *
     * @return string URL
     */
    function getProfileURL($uid)
    {
        return '';
    }

    /**
     * Retrieves the source path to the user's avatar
     *
     * @param int $uid softwares user id
     *
     * @return string with source path to users avatar
     */
    function getAvatar($uid)
    {
        return 0;
    }

    /**
     * Returns the URL to the view all private messages URL of the integrated software
     *
     * @return string URL
     */
    function getPrivateMessageURL()
    {
        return '';
    }

    /**
     * Returns the URL to a view new private messages URL of the integrated software
     *
     * @return string URL
     */
    function getViewNewMessagesURL()
    {
        return '';
    }

    /**
     * Returns the URL to a get private messages URL of the integrated software
     *
     * @param int $puser_id userid
     *
     * @return string URL
     */
    function getPrivateMessageCounts($puser_id)
    {
        return 0;
    }

    /**
     * Returns the an array with SQL statements used by the activity module
     *
     * @param array  $usedforums    array with used forums
     * @param string $result_order  ordering of results
     * @param int    $result_limit  number of results to limit by
     *
     * @return array
     */
    function getActivityQuery($usedforums, $result_order, $result_limit)
    {
        return 0;
    }

    /**
     * Returns the read status of a post based on the currently logged in user
     *
     * @param $post object with post data from the results returned from getActivityQuery
     * @return boolean
     */
    function checkReadStatus(&$post)
    {
        return 0;
    }

    /**
     * Returns the a list of forums of the integrated software
     *
     * @return array List of forums
     */
    function getForumList()
    {
        return 0;
    }

    /**
     * Filter forums from a set of results sent in / useful if the plugin needs to restrict the forums visible to a user
     *
     * @param object &$results set of results from query
     * @param int    $limit    limit results parameter as set in the module's params; used for plugins that cannot limit using a query limiter
     *
     * @return array List of result
     */
    function filterActivityResults(&$results, $limit = 0)
    {
    }

    /************************************************
    * Functions For JFusion Discussion Bot Plugin
    ***********************************************/
    /**
     * Checks to see if a thread already exists for the content item and calls the appropriate function
     *
     * @param object &$dbparams       discussion bot parameters
     * @param object &$contentitem    containing content information
     * @param object &$existingthread contains an existing thread information obtained from jos_jfusion_forum_plugin's records
     * @param int    $forumid         default forum id to create the new thread in if applicable (retrieved from $this->getDefaultForum)
     *
     * @return array Returns status of actions with errors if any
     */
    function checkThreadExists(&$dbparams, &$contentitem, &$existingthread, $forumid)
    {
        $status = array();
        $status['debug'] = array();
        $status['error'] = array();

        if (!empty($existingthread)) {
            //datetime post was last updated
            $postModified = $existingthread->modified;
            //datetime content was last updated
            $contentModified = JFactory::getDate($contentitem->modified)->toUnix();

            //check to make sure the thread still exists in the software
            $thread_exists = $this->getThread($existingthread->threadid);
            if (empty($thread_exists)) {
                //the thread no longer exists in the software!!  recreate it
                $this->createThread($dbparams, $contentitem, $forumid, $status);
                if (empty($status['error'])) {
                    $status['action'] = 'created';
                }
                return $status;
            } elseif ($contentModified > $postModified) {
                //update the post if the content has been updated
                $this->updateThread($dbparams, $existingthread, $contentitem, $status);
                if (empty($status['error'])) {
                    $status['action'] = 'updated';
                }
                return $status;
            } else {
                $status['action'] = 'unchanged';
                return $status;
            }
        } else {
            //thread does not exist; create it
            $this->createThread($dbparams, $contentitem, $forumid, $status);
            if (empty($status['error'])) {
                $status['action'] = 'created';
            }
            return $status;
        }
    }

    /**
     * Retrieves the default forum based on section/category stipulations or default set in the plugins config
     *
     * @param object &$dbparams    discussion bot parameters
     * @param object &$contentitem object containing content information
     *
     * @return int Returns id number of the forum
     */
    function getDefaultForum(&$dbparams, &$contentitem)
    {
        //content section/category
        $sectionid = & $contentitem->sectionid;
        $catid = & $contentitem->catid;
        //default forum to create post in
        $forumid = $dbparams->get("default_forum");
        //determine default forum
        $sections = $dbparams->get("pair_sections");
        $sectionPairs = empty($sections) ? false : explode(";", $sections);
        $categories = $dbparams->get("pair_categories");
        $categoryPairs = empty($categories) ? false : explode(";", $categories);
        if ($sectionPairs) {
            foreach ($sectionPairs as $pairs) {
                $pair = explode(",", $pairs);
                //check to see if this section matches the articles
                if ($pair[0] == $sectionid) {
                    $forumid = $pair[1];
                }
            }
        }
        if ($categoryPairs) {
            foreach ($categoryPairs as $pairs) {
                $pair = explode(",", $pairs);
                //check to see if this category matches the articles
                if ($pair[0] == $catid) {
                    $forumid = $pair[1];
                }
            }
        }
        return $forumid;
    }

    /**
     * Retrieves thread information
     * $result->forumid
     * $result->threadid (yes add it even though it is passed in as it will be needed in other functions)
     * $result->postid - this is the id of the first post in the thread
     *
     * @param int $threadid Id of specific thread
     *
     * @return object Returns object with thread information
     */
    function getThread($threadid)
    {
        return '';
    }

    /**
     * Function that determines the author of an article or returns the default user if one is not found
     * For the discussion bot
     *
     * @param object &$dbparams    object with discussion bot parameters
     * @param object &$contentitem contentitem
     *
     * @return int forum's userid
     */
    function getThreadAuthor(&$dbparams, &$contentitem)
    {
        if ($dbparams->get('use_article_userid', 1)) {
            //find this user in the forum
            $userinfo = JFusionFunction::lookupUser($this->getJname(), $contentitem->created_by);
            if (empty($userinfo->userid)) {
                $id = $dbparams->get('default_userid');
            } else {
                $id = $userinfo->userid;
            }
        } else {
            $id = $dbparams->get('default_userid');
        }
        return $id;
    }

    /**
     * Creates new thread and posts first post
     *
     * @param object &$params      discussion bot parameters
     * @param object &$contentitem containing content information
     * @param int    $forumid      forum to create thread
     * @param object &$status      status object for feedback of function
     *
     * @return array $status contains errors and status of actions
     */
    function createThread(&$params, &$contentitem, $forumid, &$status)
    {
    }

    /**
     * Updates information in a specific thread/post
     *
     * @param object &$params         discussion bot parameters
     * @param object &$existingthread existing thread info
     * @param object &$contentitem    content item
     * @param object &$status         status object for feedback of function
     *
     * @return array $status contains errors and status of actions
     */
    function updateThread(&$params, &$existingthread, &$contentitem, &$status)
    {
    }

    /**
     * Returns an object of columns used in createPostTable()
     * Saves from having to repeat the same code over and over for each plugin
     * For example:
     * $columns->userid = "userid";
     * $columns->username = "username";
     * $columns->name = "realName"; //if applicable
     * $columns->dateline = "dateline";
     * $columns->posttext = "pagetext";
     * $columns->posttitle = "title";
     * $columns->postid = "postid";
     * $columns->threadid = "threadid";
     * $columns->threadtitle = "threadtitle"; //optional
     * $columns->guest = "guest";
     *
     * @return object with column names
     */
    function getDiscussionColumns()
    {
        return;
    }

    /**
     * Creates a table of posts to be displayed in content item
     *
     * @param object &$dbparams       object with discussion bot parameters
     * @param object &$existingthread object with thread information
     * @param object &$posts          list of posts retrieved from getPosts();
     *
     * @return string HTML of table to displayed
     */
    function createPostTable(&$dbparams, &$existingthread, &$posts)
    {
        $columns = $this->getDiscussionColumns();
        if (empty($columns)) {
            return;
        }
        //get required params
        $public = & JFusionFactory::getPublic($this->getJname());
        defined('_DATE_FORMAT_LC2') or define('_DATE_FORMAT_LC2', '%A, %d %B %Y %H:%M');
        $date_format = $dbparams->get('custom_date', _DATE_FORMAT_LC2);
        $showdate = intval($dbparams->get('show_date'));
        $showuser = intval($dbparams->get('show_user'));
        $showavatar = $dbparams->get("show_avatar");
        $avatar_software = $dbparams->get("avatar_software", false);
        $userlink = intval($dbparams->get('user_link'));
        $link_software = $dbparams->get('userlink_software', false);
        $userlink_custom = $dbparams->get('userlink_custom', false);
        $character_limit = (int)$dbparams->get("character_limit");
        $itemid = $dbparams->get("itemid");
        $jname = $this->getJname();
        $header = $dbparams->get("post_header");
        if ($showdate && $showuser) {
            $colspan = 2;
        } else {
            $colspan = 1;
        }
        $table = "<div class='jfusionPostHeader'>$header</div>\n";
        for ($i = 0;$i < count($posts);$i++) {
            $p = & $posts[$i];
            $userid = $p->{$columns->userid};
            $username = ($dbparams->get('display_name') && isset ($p->{$columns->name})) ? $p->{$columns->name} : $p->{$columns->username};
            $dateline = $p->{$columns->dateline};
            $posttext = $p->{$columns->posttext};
            $posttitle = $p->{$columns->posttitle};
            $postid = $p->{$columns->postid};
            $threadid = $p->{$columns->threadid};
            $guest = $p->{$columns->guest};
            $threadtitle = (isset($columns->threadtitle)) ? $p->{$columns->threadtitle} : '';
            $table.= "<div class = 'jfusionPostBody' id='post{$postid}'> \n";
            //get Joomla's id
            $userlookup = JFusionFunction::lookupUser($this->getJname(), $userid, false, $p->{$columns->username});
            //avatar
            if ($showavatar) {
                if (!empty($avatar_software) && $avatar_software != 'jfusion' && !empty($userlookup)) {
                    $avatarSrc = JFusionFunction::getAltAvatar($avatar_software, $userlookup->id);
                } else {
                    $avatarSrc = $this->getAvatar($userid);
                }
                if (empty($avatarSrc)) {
                    $avatarSrc = JFusionFunction::getJoomlaURL() . 'components/com_jfusion/images/noavatar.png';
                }

                $maxheight = $dbparams->get('avatar_height', 80);
                $maxwidth = $dbparams->get('avatar_width', 60);
                $avatar = "<div class='jfusionUserAvatar'><img style='";
                $avatar.= (!empty($maxheight)) ? " max-height: {$maxheight}px;" : "";
                $avatar.= (!empty($maxwidth)) ? " max-width: {$maxwidth}px;" : "";
                $avatar.= "' src='$avatarSrc'></div>";
            } else {
                $avatar = "";
            }
            $table.= $avatar;
            //post title
            $urlstring_pre = JFusionFunction::routeURL($this->getPostURL($threadid, $postid), $itemid);
            $title = '<a href="' . $urlstring_pre . '">';
            if (!empty($posttitle)) {
                $title.= $posttitle;
            } elseif (!empty($threadtitle)) {
                $title.= "Re: " . $threadtitle;
            } else {
                $title.= JText::_('NO_SUBJECT');
            }
            $title.= '</a>';
            $table.= "<div class = 'jfusionPostTitle'>{$title}</div>\n";
            //user info
            if ($showuser) {
                if ($userlink && empty($guest) && !empty($userlookup)) {
                    if ($link_software == 'custom' && !empty($userlink_custom) && !empty($userlookup)) {
                        $user_url = $userlink_custom . $userlookup->id;
                    } elseif ($link_software == 'jfusion') {
                        $user_url = JFusionFunction::routeURL($this->getProfileURL($userid, $username), $itemid);
                    } elseif (!empty($userlookup)) {
                        $user_url = JFusionFunction::getAltProfileURL($link_software, $userlookup->id);
                    }
                    if (empty($user_url)) {
                        $user = $username;
                    } else {
                        $user = '<a href="' . $user_url . '">' . $username . '</a>';
                    }
                } elseif (!empty($guest)) {
                    $user = "$username (" . JText::_('GUEST') . ")";
                } else {
                    $user = $username;
                }
                $table.= "<div class='jfusionPostUser'> " . JText::_('BY') . " $user</div>";
            }
            //post date
            if ($showdate) {
                jimport('joomla.utilities.date');
                $tz_offset =& JFusionFunction::getJoomlaTimezone();
                $dateline += ($tz_offset * 3600);
                $date = gmstrftime($date_format, $dateline);
                $table.= "<div class='jfusionPostDate'>" . $date . "</div>";
            }
            //post body
            $status = $public->prepareText($posttext, 'joomla', $dbparams, $p);
            //apply the post body limit if there is one
            if (!empty($character_limit) && empty($status['limit_applied']) && JString::strlen($posttext) > $character_limit) {
                $posttext = JString::substr($posttext, 0, $character_limit) . '...';
            }
            $table.= "<div class='jfusionPostText'" . ((!empty($avatar)) ? " style='margin-left: {$w}px;'" : "") . ">{$posttext}</div> \n";
            $table.= "</div>";
        }
        return $table;
    }
    /**
     * Retrieves the posts to be displayed in the content item if enabled
     *
     * @param object &$params         object with discussion bot parameters
     * @param object &$existingthread object with forumid, threadid, and postid (first post in thread)
     *
     * @return array or object Returns retrieved posts
     */
    function getPosts(&$params, &$existingthread)
    {
        return array();
    }
    /**
     * Returns the total number of posts in a thread
     *
     * @param object &$existingthread object with forumid, threadid, and postid (first post in thread)
     *
     * @return int
     */
    function getReplyCount(&$existingthread)
    {
        return 0;
    }
    /**
     * Returns HTML of a quick reply
     *
     * @param object  &$dbparams       object with discussion bot parameters
     * @param boolean $showGuestInputs toggles whether to show guest inputs or not
     *
     * @return string of html
     */
    function createQuickReply(&$dbparams, $showGuestInputs)
    {
        $html = '';
        if ($showGuestInputs) {
            $username = JRequest::getVar('guest_username', '', 'post');
            $html.= "<table><tr><td>" . JText::_('USERNAME') . ":</td><td><input name='guest_username' value='$username' class='inputbox'/></td></tr>";
            $html.= $this->createCaptcha($dbparams);
            $html.= "</table><br>";
        }
        $quickReply = JRequest::getVar('quickReply', '', 'post');
        $html.= "<textarea name='quickReply' class='inputbox'>$quickReply</textarea><br>";
        $html.= "<div style='width:100%; text-align:right;'><input type='submit' value='" . JText::_('SUBMIT') . "'/></div>";
        return $html;
    }

    /**
     * Creates the html for the selected captcha for the discussion bot
     *
     * @param object $dbparams object with discussion bot parameters
     *
     * @return unknown_type
     */
    function createCaptcha($dbparams)
    {
        $html = '';
        $captcha_mode = $dbparams->get('captcha_mode', 'disabled');
        switch ($captcha_mode) {
        case 'question':
            //answer/question method
            $question = $dbparams->get('captcha_question');
            if (!empty($question)) {
                $html.= "<tr><td>$question:</td><td><input name='captcha_answer' value='' class='inputbox'/></td></tr>";
            }
            break;
        case 'joomla15captcha':
            //using joomla15captcha (http://code.google.com/p/joomla15captcha)
            $dispatcher = & JDispatcher::getInstance();
            $results = $dispatcher->trigger('onCaptchaRequired', array('jfusion.discussion'));
            if ($results[0]) {
                ob_start();
            }
            $dispatcher->trigger('onCaptchaView', array('jfusion.discussion', 0, '<tr><td colspan=2><br />', '<br /></td></tr>'));
            $html.= ob_get_contents();
            ob_end_clean();
            break;
        case 'recaptcha':
            //using reCAPTCHA (http://recaptcha.net)
            $recaptchalib = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'recaptchalib.php';
            if (file_exists($recaptchalib)) {
                $theme = $dbparams->get('recaptcha_theme', 'red');
                $lang = $dbparams->get('recaptcha_lang', 'en');
                $document = & JFactory::getDocument();
                $script.= "<script>\n";
                $script.= "var RecaptchaOptions = {\n";
                $script.= "theme : '$theme',\n";
                $script.= "lang: '$lang'\n";
                $script.= "};\n";
                $script.= "</script>\n";
                $document->addCustomTag($script);
                $html.= "<tr><td colspan=2>";
                include_once $recaptchalib;
                $error = null;
                $publickey = $dbparams->get('recaptcha_publickey');
                $html.= recaptcha_get_html($publickey, $error);
                if (!empty($error)) {
                    $html.= $error;
                }
                $html.= "</td></tr>";
            }
            break;
        case 'custom':
            $html.= $this->createCustomCaptcha($dbparams);
            break;
        default:
            break;
        }
        return $html;
    }

    /**
     * Creates custom captcha html for this plugin
     *
     * @param object &$dbparams object with discussion bot parameters
     *
     * @return string with html
     */
    function createCustomCaptcha(&$dbparams)
    {
        JFusionFunction::raiseWarning($this->getJname() . ' ' . JText::_('DISCUSSBOT_ERROR'), JText::_('CUSTOM_CAPTCHA_NOT_IMPLEMENTED'), 1);
        return '';
    }

    /**
     * Verifies captcha of a guest post submitted by the discussion bot
     *
     * @param object &$dbparams object with discussion bot parameters
     *
     * @return boolean
     */
    function verifyCaptcha(&$dbparams)
    {
        //let's check for captcha
        $captcha_mode = $dbparams->get('captcha_mode', 'disabled');
        $captcha_verification = false;
        switch ($captcha_mode) {
        case 'question':
            //question/answer method
            $captcha_answer = JRequest::getVar('captcha_answer', '', 'POST');
            if (!empty($captcha_answer) && $captcha_answer == $dbparams->get('captcha_answer')) {
                $captcha_verification = true;
            }
            break;
        case "joomla15captcha":
            //using joomla15captcha (http://code.google.com/p/joomla15captcha)
            $dispatcher = & JDispatcher::getInstance();
            $results = $dispatcher->trigger('onCaptchaRequired', array('jfusion.discussion'));
            if ($results[0]) {
                $captchaparams = array(JRequest::getVar('captchacode', '', 'post'), JRequest::getVar('captchasuffix', '', 'post'), JRequest::getVar('captchasessionid', '', 'post'));
                $results = $dispatcher->trigger('onCaptchaVerify', $captchaparams);
                if ($results[0]) {
                    $captcha_verification = true;
                }
            }
            break;
        case 'recaptcha':
            //using reCAPTCHA (http://recaptcha.net)
            $recaptchalib = JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'recaptchalib.php';
            if (file_exists($recaptchalib)) {
                include_once $recaptchalib;
                $privatekey = $dbparams->get('recaptcha_privatekey');
                $response_field = JRequest::getVar('recaptcha_response_field', '', 'post', 'string');
                $challenge_field = JRequest::getVar('recaptcha_challenge_field', '', 'post', 'string');
                $resp = recaptcha_check_answer($privatekey, $_SERVER["REMOTE_ADDR"], $challenge_field, $response_field);
                if ($resp->is_valid) {
                    $captcha_verification = true;
                }
            }
            break;
        case 'disabled':
            $captcha_verification = true;
            break;
        default:
            $captcha_verification = $this->verifyCustomCaptcha($dbparams);
            break;
        }
        if (!$captcha_verification) {
            JFusionFunction::raiseWarning($this->getJname() . ' ' . JText::_('DISCUSSBOT_ERROR'), JText::_('CAPTCHA_INCORRECT'), 1);
        }
        return $captcha_verification;
    }

    /**
     * Verifies custom captcha of a JFusion plugin
     *
     * @param object &$dbparams object with discussion bot parameters
     *
     * @return boolean
     */
    function verifyCustomCaptcha(&$dbparams)
    {
        JFusionFunction::raiseWarning($this->getJname() . ' ' . JText::_('DISCUSSBOT_ERROR'), JText::_('CUSTOM_CAPTCHA_NOT_IMPLEMENTED'), 1);
        return false;
    }

    /**
     * Creates a post from the quick reply
     *
     * @param object &$params      object with discussion bot parameters
     * @param array  &$ids         array with forum id ($ids["forumid"], thread id ($ids["threadid"]) and first post id ($ids["postid"])
     * @param object &$contentitem object of content item
     * @param object &$userinfo    object info of the forum user
     *
     * @return array with status
     */
    function createPost(&$params, &$ids, &$contentitem, &$userinfo)
    {
        $status = array();
        $status["error"] = false;
        return $status;
    }
}
