<?php

/**
 *
 * PHP version 5
 *
 * @category   JFusion
 * @package    JFusionPlugins
 * @subpackage vBulletin
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
*/

// no direct access
defined('_JEXEC' ) or die('Restricted access' );

/**
 * JFusion Admin Class for vBulletin
 * For detailed descriptions on these functions please check the model.abstractadmin.php
 *
 * @category   JFusion
 * @package    JFusionPlugins
 * @subpackage vBulletin
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
*/
class JFusionUser_vbulletin extends JFusionUser
{
    var $params;
    var $helper;

    function JFusionUser_vbulletin()
    {
        //get the params object
        $this->params =& JFusionFactory::getParams($this->getJname());
        //get the helper object
        $this->helper = & JFusionFactory::getHelper($this->getJname());
    }

    function &getUser($userinfo, $identifier_type = 'auto', $ignore_id = 0)
    {
    	if($identifier_type == 'auto') {
        	//get the identifier
        	list($identifier_type,$identifier) = $this->getUserIdentifier($userinfo,'u.username','u.email');
        	if ($identifier_type == 'u.username') {
        	    //lower the username for case insensitivity purposes
        	    $identifier_type = 'LOWER(u.username)';
        	    $identifier = strtolower($identifier);
        	}
    	} else {
    		$identifier_type = 'u.' . $identifier_type;
    		$identifier = $userinfo;
    	}

        // Get user info from database
        $db =& JFusionFactory::getDatabase($this->getJname());

        $name_field = $this->params->get('name_field');

        $query = "SELECT u.userid, u.username, u.email, u.usergroupid AS group_id, u.membergroupids, u.displaygroupid, u.password, u.salt as password_salt, u.usertitle, u.customtitle, u.posts, u.username as name FROM #__user AS u WHERE " . $identifier_type . ' = ' . $db->Quote($identifier);
        $query.= ($ignore_id) ? " AND u.userid != $ignore_id" : "";

        $db->setQuery($query );
        $result = $db->loadObject();

        if ($result) {
            $query = "SELECT title FROM #__usergroup WHERE usergroupid = {$result->group_id}";
            $db->setQuery($query);
            $result->group_name = $db->loadResult();

            if (!empty($name_field)) {
                $query = "SELECT $name_field FROM #__userfield WHERE userid = {$result->userid}";
                $db->setQuery($query);
                $name = $db->loadResult();
                if (!empty($name)) {
                    $result->name = $name;
                }
            }
            //Check to see if they are banned
            $query = 'SELECT userid FROM #__userban WHERE userid='. $result->userid;
            $db->setQuery($query);
            if ($db->loadObject() || ($this->params->get('block_coppa_users', 1) && (int) $result->group_id == 4)) {
                $result->block = 1;
            } else {
                $result->block = 0;
            }

            //check to see if the user is awaiting activation
            $activationgroup = $this->params->get('activationgroup');

            if ($activationgroup == $result->group_id) {
                jimport('joomla.user.helper');
                $result->activation = JUserHelper::genRandomPassword(32);
            } else {
                $result->activation = '';
            }
        }
        return $result;
    }

    /**
     * returns the name of this JFusion plugin
     * @return string name of current JFusion plugin
     */
    function getJname()
    {
        return 'vbulletin';
    }

    function getTablename()
    {
        return 'user';
    }

    function deleteUser($userinfo)
    {
        //setup status array to hold debug info and errors
        $status = array();
        $status['debug'] = array();
        $status['error'] = array();

        //backup Joomla's global scope
        $this->helper->backupJoomla();

        //initialize vb framework
        if (!$this->helper->vBulletinInit()) {
            return null;
        }

        //setup the existing user
        $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
        $existinguser = $this->helper->convertUserData($userinfo);
        $userdm->set_existing($existinguser);

        //delete the user
        $userdm->delete();
        if (!empty($userdm->errors)) {
            foreach ($userdm->errors AS $index => $error)
            {
                $status['error'][] = JText::_('USER_DELETION_ERROR') . ' ' . $error;
            }
        } else {
            $status['error'] = false;
            $status['debug'][] = JText::_('USER_DELETION'). ' ' . $existinguser->userid;
        }
        unset($userdm);

        //restore Joomla's global scope
        $this->helper->restoreJoomla();

        return $status;
    }

    function destroySession($userinfo, $options)
    {
        $status = array();
        $status['error'] = array();
        $status['debug'] = array();

        $cookie_prefix = $this->params->get('cookie_prefix');
        $vbversion = & $this->helper->getVersion();
        if ((int) substr($vbversion, 0, 1) > 3) {
           if (substr($cookie_prefix, -1) !== '_') {
               $cookie_prefix .= '_';
           }
        }
        $cookie_domain = $this->params->get('cookie_domain');
        $cookie_path = $this->params->get('cookie_path');
        $cookie_salt = $this->params->get('cookie_salt');
        $secure = $this->params->get('secure',false);
        $httponly = $this->params->get('httponly',true);
        $timenow = time();

        //If blocking a user in Joomla's User Manager, Joomla will initiate a logout.
        //Thus, prevent a logout of the currently logged in user if a user has been blocked:
        if (!defined('VBULLETIN_BLOCKUSER_CALLED')) {
            require_once JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.curl.php';
            $brute_force = false;
            if (function_exists('curl_init')) {
                global $ch;
                global $cookiearr;
                global $cookies_to_set;
                global $cookies_to_set_index;
                $cookiearr = array();
                $cookies_to_set = array();
                $cookies = array();
                $cookie = array();
                $curl_options = array();
                $cookies_to_set_index = 0;

                $curl_options['post_url'] = $this->params->get('source_url') . 'login.php?do=logout&noredirect=1';
                $curl_options['cookiedomain'] = $this->params->get('cookie_domain');
                $curl_options['cookiepath'] = $this->params->get('cookie_path');
                $curl_options['leavealone'] = $this->params->get('leavealone');
                $curl_options['secure'] = $this->params->get('secure');
                $curl_options['httponly'] = $this->params->get('httponly');
                $curl_options['verifyhost'] = 0;
                $curl_options['httpauth'] = $this->params->get('httpauth');
                $curl_options['httpauth_username'] = $this->params->get('curl_username');
                $curl_options['httpauth_password'] = $this->params->get('curl_password');

                //add on vBulletin's logouthash to the url
                $securitytoken = sha1($userinfo->userid . sha1($userinfo->password_salt) . sha1($cookie_salt));

                $logouthash = $timenow . '-' . sha1($timenow . $securitytoken);
                $curl_options['post_url'] .= '&logouthash=' . $logouthash;

                $my_ID = rtrim(parse_url(JURI::root(), PHP_URL_HOST).parse_url(JURI::root(), PHP_URL_PATH), '/');
                $curl_options['jnodeid'] = $my_ID;

                $status = JFusionCurl::RemoteLogoutUrl($curl_options);
                $status['debug'][] = JText::sprintf('LOGOUT_PERFORMED_VIA',$curl_options['post_url']);

                if (!empty($status['error'])) {
                    $status['debug'][] = $status['error'];
                    unset($status['error']);
                    $brute_force = true;
                }
            } else {
                $brute_force = true;
            }

            if ($brute_force) {
                JFusionCurl::addCookie($cookie_prefix.'userid' , 0, $timenow - 3600, $cookie_path, $cookie_domain, $secure, $httponly);
                JFusionCurl::addCookie($cookie_prefix.'password' , 0, $timenow - 3600, $cookie_path, $cookie_domain, $secure, $httponly);
                JFusionCurl::addCookie($cookie_prefix.'sessionhash' , 0, $timenow - 3600, $cookie_path, $cookie_domain, $secure, $httponly);
                $status['debug'][] = JText::_('CURL_DISABLED');
                $status['debug'][] = "{$cookie_prefix}userid " . JText::_('DELETED');
                $status['debug'][] = "{$cookie_prefix}password " . JText::_('DELETED');
                $status['debug'][] = "{$cookie_prefix}sessionhash " . JText::_('DELETED');
            }

            return $status;
        } else {
            $status = array();
            $status['debug'] = 'Joomla initiated a logout of a blocked user thus skipped vBulletin destroySession() to prevent current user from getting logged out.';
        }
    }

    function createSession(&$userinfo, $options)
    {
        require_once JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.curl.php';

         $status = array();
         $status['error'] = array();
         $status['debug'] = array();

        //do not create sessions for blocked users
        if (!empty($userinfo->block) || !empty($userinfo->activation)) {
            $status['error'][] = JText::_('FUSION_BLOCKED_USER');
            return $status;
        }

        //first check to see if striking is enabled to prevent further strikes
        $db =& JFusionFactory::getDatabase($this->getJname());
        $query = "SELECT value FROM #__setting WHERE varname = 'usestrikesystem'";
        $db->setQuery($query);
        $strikeEnabled = $db->loadResult();

        if ($strikeEnabled) {
            $ip = $_SERVER['REMOTE_ADDR'];
            $time = strtotime("-15 minutes");
            $query = "SELECT COUNT(*) FROM #__strikes WHERE strikeip = '$ip' AND striketime >= $time";
            $db->setQuery($query);
            $strikes = $db->loadResult();

            if ($strikes >= 5) {
                $status = array();
                $status['error'] = JText::_('VB_TOO_MANY_STRIKES');
                return $status;
            }
        }

        //make sure a session is not already active for this user
        $cookie_prefix = $this->params->get('cookie_prefix');
        $vbversion = & $this->helper->getVersion();
        if ((int) substr($vbversion, 0, 1) > 3) {
           if (substr($cookie_prefix, -1) !== '_') {
               $cookie_prefix .= '_';
           }
        }
        $cookie_salt = $this->params->get('cookie_salt');
        $cookie_domain = $this->params->get('cookie_domain');
        $cookie_path = $this->params->get('cookie_path');
        $cookie_expires  = (!empty($options['remember'])) ? 0 : $this->params->get('cookie_expires');
        if ($cookie_expires == 0) {
            $expires_time = time() + (60 * 60 * 24 * 365);
        } else {
            $expires_time = time() + ( 60 * $cookie_expires );
        }
        $debug_expiration = date("Y-m-d H:i:s", $expires_time);
        $passwordhash = md5($userinfo->password.$cookie_salt);

        $query = "SELECT sessionhash FROM #__session WHERE userid = " . $userinfo->userid;
        $db->setQuery($query);
        $sessionhash = $db->loadResult();

        $cookie_sessionhash = JRequest::getVar($cookie_prefix . "sessionhash", '', 'cookie');
        $cookie_userid = JRequest::getVar($cookie_prefix . "userid", '', 'cookie');
        $cookie_password = JRequest::getVar($cookie_prefix . "password", '', 'cookie');

        if (!empty($cookie_userid) && $cookie_userid == $userinfo->userid && !empty($cookie_password) && $cookie_password == $passwordhash) {
            $vbcookieuser = true;
        } else {
            $vbcookieuser = false;
        }

        if (!$vbcookieuser && (empty($cookie_sessionhash) || $sessionhash != $cookie_sessionhash)) {
            $secure = $this->params->get('secure', false);
            $httponly = $this->params->get('httponly', true);

            JFusionCurl::addCookie($cookie_prefix.'userid' , $userinfo->userid, $expires_time,  $cookie_path, $cookie_domain, $secure, $httponly);
            JFusionCurl::addCookie($cookie_prefix.'password' , $passwordhash, $expires_time, $cookie_path, $cookie_domain, $secure, $httponly);

            $status['debug'][JText::_('CREATED') . ' ' . JText::_('COOKIES')][] = array(JText::_('NAME') => $cookie_prefix.'userid', JText::_('VALUE') => $userinfo->userid, JText::_('EXPIRES') => $debug_expiration, JText::_('COOKIE_PATH') => $cookie_path, JText::_('COOKIE_DOMAIN') => $cookie_domain);
            $status['debug'][JText::_('CREATED') . ' ' . JText::_('COOKIES')][] = array(JText::_('NAME') => $cookie_prefix.'password', JText::_('VALUE') => substr($passwordhash, 0, 6) . '********, ', JText::_('EXPIRES') => $debug_expiration, JText::_('COOKIE_PATH') => $cookie_path, JText::_('COOKIE_DOMAIN') => $cookie_domain);
        } else {
            $status['debug'][] = JText::_('VB_SESSION_ALREADY_ACTIVE');
            $status['debug'][JText::_('COOKIES')][] = array(JText::_('NAME') => $cookie_prefix.'userid', JText::_('VALUE') => $cookie_userid, JText::_('EXPIRES') => $debug_expiration, JText::_('COOKIE_PATH') => $cookie_path, JText::_('COOKIE_DOMAIN') => $cookie_domain);
            $status['debug'][JText::_('COOKIES')][] = array(JText::_('NAME') => $cookie_prefix.'password', JText::_('VALUE') => substr($cookie_password, 0, 6) . '********, ', JText::_('EXPIRES') => $debug_expiration, JText::_('COOKIE_PATH') => $cookie_path, JText::_('COOKIE_DOMAIN') => $cookie_domain);
            $status['debug'][JText::_('COOKIES')][] = array(JText::_('NAME') => $cookie_prefix.'sessionhash', JText::_('VALUE') => $cookie_sessionhash, JText::_('EXPIRES') => $debug_expiration, JText::_('COOKIE_PATH') => $cookie_path, JText::_('COOKIE_DOMAIN') => $cookie_domain);
        }

        return $status;
    }

    function filterUsername($username)
    {
        //lower username for case insensitivity purposes
        return strtolower($username);
    }

    function updatePassword($userinfo, &$existinguser, &$status)
    {
        jimport('joomla.user.helper');
        $existinguser->password_salt = JUserHelper::genRandomPassword(3);
        $existinguser->password = md5(md5($userinfo->password_clear).$existinguser->password_salt);

        $date = date('Y-m-d');

        $db =& JFusionFactory::getDatabase($this->getJname());
        $query = 'UPDATE #__user SET passworddate = ' . $db->Quote($date) . ', password = ' . $db->Quote($existinguser->password). ', salt = ' . $db->Quote($existinguser->password_salt). ' WHERE userid  = ' . $existinguser->userid;
        $db->setQuery($query );
        if (!$db->query()) {
            $status['error'][] = JText::_('PASSWORD_UPDATE_ERROR')  . ': ' . $db->stderr();
        } else {
            $status['debug'][] = JText::_('PASSWORD_UPDATE') . ' ' . substr($existinguser->password,0,6) . '********';
        }
    }

    function updateEmail($userinfo, &$existinguser, &$status)
    {
		//backup Joomla's global scope
		$this->helper->backupJoomla();

    	//initialize vb framework
		if(!$this->helper->vBulletinInit()) return null;

		//setup the existing user
		$userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
		$userdm->set_existing($this->helper->convertUserData($existinguser));

		$userdm->set('email', $userinfo->email);

		//performs some final VB checks before saving
		$userdm->pre_save();
	    if(empty($userdm->errors)){
			$userdm->save();
		    $status['debug'][] = JText::_('EMAIL_UPDATE'). ': ' . $existinguser->email . ' -> ' . $userinfo->email;
        } else {
    		foreach ($userdm->errors AS $index => $error) {
        		$status['error'][] = JText::_('EMAIL_UPDATE_ERROR') . ' ' . $error;
            }
        }

	    unset($userdm);

		//restore Joomla's global scope
		$this->helper->restoreJoomla();
    }

    function blockUser (&$userinfo, &$existinguser, &$status)
    {
        //backup Joomla's global scope
        $this->helper->backupJoomla();

        //initialize vb framework
        if (!$this->helper->vBulletinInit()) {
            return null;
        }

        $db =& JFusionFactory::getDatabase($this->getJname());

        //get the id of the banned group
        $bannedgroup = $this->params->get('bannedgroup');

        //update the usergroup to banned
        $query = 'UPDATE #__user SET usergroupid = ' . $bannedgroup . ' WHERE userid  = ' . $existinguser->userid;
        $db->setQuery($query);

        if (!$db->query()) {
            $status['error'][] = JText::_('BLOCK_UPDATE_ERROR') . ': ' . $db->stderr();
        } else {

            //add a banned user catch to vbulletin's database
            $ban = new stdClass;
            $ban->userid = $existinguser->userid;
            $ban->usergroupid = $existinguser->group_id;
            $ban->displaygroupid = $existinguser->displaygroupid;
            $ban->customtitle = $existinguser->customtitle;
            $ban->usertitle = $existinguser->usertitle;
            $ban->adminid = 1;
            $ban->bandate = time();
            $ban->liftdate = 0;
            $ban->reason = (!empty($status['aec'])) ? $status['block_message'] : $this->params->get('blockmessage');

            //now append or update the new user data
            $query = "SELECT COUNT(*) FROM #__userban WHERE userid = " . $existinguser->userid;
            $db->setQuery($query);
            $banned = $db->loadResult();

            $result = ($banned) ?  $db->updateObject('#__userban', $ban, 'userid' ) : $db->insertObject('#__userban', $ban, 'userid' );
            if (!$result) {
                $status['error'][] = JText::_('BLOCK_UPDATE_ERROR') . ': ' . $db->stderr();
            } else {
                $status['debug'][] = JText::_('BLOCK_UPDATE'). ': ' . $existinguser->block . ' -> ' . $userinfo->block;
            }
        }

        //backup Joomla's global scope
        $this->helper->restoreJoomla();

        //note that blockUser has been called
        if (empty($status['aec'])) {
            define('VBULLETIN_BLOCKUSER_CALLED',1);
        }
    }

    function unblockUser($userinfo, &$existinguser, &$status)
    {
        //backup Joomla's global scope
        $this->helper->backupJoomla();

        //initialize vb framework
        if (!$this->helper->vBulletinInit()) {
            return null;
        }

        //found out what usergroup should be used
        $usergroups = (substr($this->params->get('usergroup'), 0, 2) == 'a:') ? unserialize($this->params->get('usergroup')) : $this->params->get('usergroup');
        if (is_array($usergroups)) {
            $defaultgroup = $usergroups[$userinfo->group_id]['defaultgroup'];
            $displaygroup = $usergroups[$userinfo->group_id]['displaygroup'];
        } else {
            $defaultgroup = $usergroups;
            $displaygroup = $usergroups;
        }
        $bannedgroup = $this->params->get('bannedgroup');

        //setup the existing user
        $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
        $userinfo = $this->helper->convertUserData($existinguser);

        $userdm->set_existing($userinfo);

        //first check to see if user is banned and if so, retrieve the prebanned fields
        //must be something other than $db because it conflicts with vbulletin's global variables
        $jdb =& JFusionFactory::getDatabase($this->getJname());
        $query = 'SELECT b.*, g.usertitle AS bantitle FROM #__userban AS b INNER JOIN #__user AS u ON b.userid = u.userid INNER JOIN #__usergroup AS g ON u.usergroupid = g.usergroupid WHERE b.userid = ' . $existinguser->userid;
        $jdb->setQuery($query );
        $result = $jdb->loadObject();

        if ($result) {
            //set the user title
            if ($result->customtitle && $result->usertitle!=$result->bantitle) {
                $usertitle = $result->usertitle;
            } else if (!empty($result->usertitle)) {
                $usertitle = $result->usertitle;
            } else {
                $usertitle = $this->getDefaultUserTitle($defaultgroup, $existinguser->posts);
            }

            $userdm->set('usertitle', $usertitle);
            $userdm->set('posts', $existinguser->posts);
            // This will activate the rank update

            //keep user from getting stuck as banned
            if ($result->usergroupid==$bannedgroup) {
                $usergroupid = $defaultgroup;
            } else {
                $usergroupid = $result->group_id;
            }
            if ($result->displaygroupid==$bannedgroup) {
                $displaygroupid = $displaygroup;
            } else {
                $displaygroupid = $result->displaygroupid;
            }

            $userdm->set('usergroupid', $usergroupid);
            $userdm->set('displaygroupid', $displaygroupid);
            $userdm->set('customtitle', $result->customtitle);

            //remove any banned user catches from vbulletin's database
            $query = 'DELETE FROM #__userban WHERE userid='. $existinguser->userid;
            $jdb->setQuery($query);
            if (!$jdb->Query()) {
                $status['error'][] = JText::_('BLOCK_UPDATE_ERROR') . ': ' . $jdb->stderr();
            }
        } else {
            $userdm->set('usergroupid', $defaultgroup);
            $userdm->set('displaygroupid', $displaygroup);
        }

        //performs some final VB checks before saving
        $userdm->pre_save();
        if (empty($userdm->errors)) {

            $userdm->save();

            $status['debug'][] = JText::_('BLOCK_UPDATE'). ': ' . $existinguser->block . ' -> ' . $userinfo->block;
        } else {
            foreach ($userdm->errors AS $index => $error) {
                $status['error'][] = JText::_('BLOCK_UPDATE_ERROR') . ' ' . $error;
            }
        }

        unset($userdm);

        //backup Joomla's global scope
        $this->helper->restoreJoomla();
    }

    function activateUser($userinfo, &$existinguser, &$status)
    {
        //found out what usergroup should be used
        $usergroups = (substr($this->params->get('usergroup'), 0, 2) == 'a:') ? unserialize($this->params->get('usergroup')) : $this->params->get('usergroup');
        $usergroup = (is_array($usergroups)) ? $usergroups[$userinfo->group_id]['defaultgroup'] : $usergroups;

        //update the usergroup to default group
        $db =& JFusionFactory::getDatabase($this->getJname());
        $query = 'UPDATE #__user SET usergroupid = ' . $usergroup . ' WHERE userid  = ' . $existinguser->userid;
        $db->setQuery($query );

        if ($db->query()) {
            //remove any activation catches from vbulletins database
            $query = 'DELETE FROM #__useractivation WHERE userid = ' . $existinguser->userid;
            $db->setQuery($query);

            if (!$db->Query()) {
                $status['error'][] = JText::_('ACTIVATION_UPDATE_ERROR') . ': ' . $db->stderr();
            } else {
                $status['debug'][] = JText::_('ACTIVATION_UPDATE'). ': ' . $existinguser->activation . ' -> ' . $userinfo->activation;
            }
        } else {
            $status['error'][] = JText::_('ACTIVATION_UPDATE_ERROR') . ': ' . $db->stderr();
        }
    }

    function inactivateUser($userinfo, &$existinguser, &$status)
    {
        //found out what usergroup should be used
        $usergroup = $this->params->get('activationgroup');

        //update the usergroup to awaiting activation
        $db =& JFusionFactory::getDatabase($this->getJname());
        $query = 'UPDATE #__user SET usergroupid = ' . $usergroup . ' WHERE userid  = ' . $existinguser->userid;
        $db->setQuery($query );

        if ($db->Query()) {
            //update the activation status
            //check to see if the user is already inactivated
            $query = 'SELECT COUNT(*) FROM #__useractivation WHERE userid = ' . $existinguser->userid;
            $db->setQuery($query);
            $count = $db->loadResult();
            if (empty($count)) {
                //if not, then add an activation catch to vbulletin's database
                $useractivation = new stdClass;
                $useractivation->userid = $existinguser->userid;
                $useractivation->dateline = time();
                jimport('joomla.user.helper');
                $useractivation->activationid = JUserHelper::genRandomPassword(40);

                $usergroups = (substr($this->params->get('usergroup'), 0, 2) == 'a:') ? unserialize($this->params->get('usergroup')) : $this->params->get('usergroup');
                $usergroup = (is_array($usergroups)) ? $usergroups[$userinfo->group_id]['defaultgroup'] : $usergroups;
                $useractivation->usergroupid = $usergroup;

                if ($db->insertObject('#__useractivation', $useractivation, 'useractivationid' )) {

                    //backup Joomla's global scope
                    $this->helper->backupJoomla();

                    //initialize vb framework
                    if ($this->helper->vBulletinInit()) {
                        //setup the existing user
                        $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
                        $vbuser = $this->helper->convertUserData($existinguser);
                        $userdm->set_existing($vbuser);
                        $userdm->set_bitfield('options', 'noactivationmails', 0);
                        $userdm->save();
                    }

                    //restore Joomla's global scope
                    $this->helper->restoreJoomla();

                    $status['debug'][] = JText::_('ACTIVATION_UPDATE'). ': ' . $existinguser->activation . ' -> ' . $userinfo->activation;
                } else {
                    $status['error'][] = JText::_('ACTIVATION_UPDATE_ERROR') . ': ' . $db->stderr();
                }
            } else {
                $status['debug'][] = JText::_('ACTIVATION_UPDATE'). ': ' . $existinguser->activation . ' -> ' . $userinfo->activation;
            }
        } else {
            $status['error'][] = JText::_('ACTIVATION_UPDATE_ERROR') . ': ' . $db->stderr();
        }
    }

    function createUser($userinfo, &$status)
    {
        //get the default user group and determine if we are using simple or advanced
        $usergroups = (substr($this->params->get('usergroup'), 0, 2) == 'a:') ? unserialize($this->params->get('usergroup')) : $this->params->get('usergroup');

        //return if we are in advanced user group mode but the master did not pass in a group_id
        if (is_array($usergroups) && !isset($userinfo->group_id)) {
            $status['error'][] = JText::_('GROUP_UPDATE_ERROR'). ": " . JText::_('ADVANCED_GROUPMODE_MASTER_NOT_HAVE_GROUPID');
            return null;
        }

        //backup Joomla's global scope
        $this->helper->backupJoomla();

        //initialize vb framework
        if (!$this->helper->vBulletinInit()) {
            return null;
        }

        if (empty($userinfo->activation)) {
            $defaultgroup = (is_array($usergroups)) ? $usergroups[$userinfo->group_id]['defaultgroup'] : $usergroups;
            $setAsNeedsActivation = false;
        } else {
            $defaultgroup = $this->params->get('activationgroup');
            $setAsNeedsActivation = true;
        }

        //create the new user
        $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
        $userdm->set('username', $userinfo->username);
        $userdm->set('email', $userinfo->email);

        if (is_array($usergroups)) {
            $userdm->set('usergroupid', $defaultgroup);
            $userdm->set('displaygroupid', $usergroups[$userinfo->group_id]['displaygroup']);
            $userdm->set('membergroupids', $usergroups[$userinfo->group_id]['membergroups']);
        } else {
            $userdm->set('usergroupid', $defaultgroup);
            $userdm->set('displaygroupid', 0);
        }

        $usertitle = $this->getDefaultUserTitle($defaultgroup);

        $userdm->set('usertitle',$usertitle);

        if (isset($userinfo->password_clear)) {
            $userdm->set('password', $userinfo->password_clear);
        } else {
            //clear password is not available, set a random password for now
            jimport('joomla.user.helper');
            $random_password = JUtility::getHash(JUserHelper::genRandomPassword(10));
            $userdm->set('password', $random_password);
        }

        //set the timezone
        if (isset($userinfo->timezone)) {
            $timezone = $userinfo->timezone;
        } else {
            $config =& JFactory::getConfig();
            $timezone = $config->getValue('config.offset',0);
        }
        $userdm->set('timezoneoffset', $timezone);

        //performs some final VB checks before saving
        $userdm->pre_save();
        if (empty($userdm->errors)) {
            $userdmid = $userdm->save();

            //if we set a temp password, we need to move the hashed password over
            if (!isset($userinfo->password_clear)) {
                $db =& JFusionFactory::getDatabase($this->getJname());
                $query = 'UPDATE #__user SET password = ' . $db->Quote($userinfo->password). ' WHERE userid  = ' . $userdmid;
                if (!$db->query()) {
                    $status['debug'][] = JText::_('USER_CREATION_ERROR') .'. '. JText::_('USERID') . ' ' . $userdmid . ': '.JText::_('MASTER_PASSWORD_NOT_COPIED');
                }
            }

            //save the new user
            $status['userinfo'] = $this->getUser($userinfo);

            //does the user still need to be activated?
            if ($setAsNeedsActivation) {
                $this->inactivateUser($userinfo, $status['userinfo'], $status);
            }

            //return the good news
            $status['debug'][] = JText::_('USER_CREATION') .'. '. JText::_('USERID') . ' ' . $userdmid;
        } else {
            foreach ($userdm->errors AS $index => $error)
            {
                $status['error'][] = JText::_('USER_CREATION_ERROR') . ' ' . $error;
            }
        }

        unset($userdm);
        //backup Joomla's global scope
        $this->helper->restoreJoomla();
    }

    function executeUpdateUsergroup(&$userinfo, &$existinguser, &$usergroups, &$status)
    {
        $update_groups = false;
        $usergroupid =& $usergroups[$userinfo->group_id]['defaultgroup'];
        $displaygroupid =& $usergroups[$userinfo->group_id]['displaygroup'];
        $membergroupids = (isset($usergroups[$userinfo->group_id]['membergroups'])) ? $usergroups[$userinfo->group_id]['membergroups'] : array();

        //check to see if the default groups are different
        if ($usergroupid != $existinguser->group_id ) {
            $update_groups = true;
        }

        //check to see if the display groups are different
        if (!empty($usergroups['options']['compare_displaygroups']) && $displaygroupid != $existinguser->displaygroupid ) {
            $update_groups = true;
        }

        //check to see if member groups are different
        if (!empty($usergroups['options']['compare_membergroups'])) {
            $current_membergroups = explode(',', $existinguser->membergroupids);
            foreach ($membergroupids as $gid) {
                if (!in_array($gid, $current_membergroups)) {
                    $update_groups = true;
                    break;
                }
            }
        }

        if ($update_groups) {
            $this->updateUsergroup($userinfo, $existinguser, $status);
        }

        return $update_groups;
    }

    function updateUsergroup($userinfo, &$existinguser, &$status)
    {
        //check to see if we have a group_id in the $userinfo, if not return
        if (!isset($userinfo->group_id)) {
            $status['error'][] = JText::_('GROUP_UPDATE_ERROR'). ": " . JText::_('ADVANCED_GROUPMODE_MASTER_NOT_HAVE_GROUPID');
            return null;
        }

        $usergroups = unserialize($this->params->get('usergroup'));
        if (isset($usergroups[$userinfo->group_id])) {
            //backup Joomla's global scope
            $this->helper->backupJoomla();

            //initialize vb framework
            if (!$this->helper->vBulletinInit()) {
                return null;
            }

            //setup the existing user
            $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
            $vbuserinfo = $this->helper->convertUserData($existinguser);
            $userdm->set_existing($vbuserinfo);

            $defaultgroup =& $usergroups[$userinfo->group_id]['defaultgroup'];
            $displaygroup =& $usergroups[$userinfo->group_id]['displaygroup'];
            $membergroups =& $usergroups[$userinfo->group_id]['membergroups'];

            $userdm->set('usergroupid', $defaultgroup);
            $userdm->set('membergroupids', $membergroups);

            $titlegroupid = (!empty($displaygroup)) ? $displaygroup : $defaultgroup;
            $usertitle = $this->getDefaultUserTitle($titlegroupid);
            $userdm->set('usertitle',$usertitle);

            //performs some final VB checks before saving
            $userdm->pre_save();
            if (empty($userdm->errors)) {
                $userdm->save();

                //now save the displaygroup
                if (!empty($displaygroup)) {
                    unset($userdm);
                    $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
                    $userdm->set_existing($vbuserinfo);
                    $userdm->set('displaygroupid', $displaygroup);
                    $userdm->pre_save();
                    if (empty($userdm->errors)) {
                        $userdm->save();
                    } else {
                        foreach ($userdm->errors AS $index => $error) {
                            $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . $error;
                        }
                    }
                }

                $status['debug'][] = JText::_('GROUP_UPDATE'). ': ' . $existinguser->group_id . ' -> ' . $usergroups[$userinfo->group_id]['defaultgroup'];
            } else {
                foreach ($userdm->errors AS $index => $error) {
                    $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . $error;
                }
            }

            unset($userdm);

            //restore Joomla's global scope
            $this->helper->restoreJoomla();

        } else {
            $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . JText::_('ADVANCED_GROUPMODE_MASTERGROUP_NOTEXIST');
        }

    }

    //returns the user's title based on number of posts
    function getDefaultUserTitle($groupid, $posts = 0)
    {
        $db =& JFusionFactory::getDatabase($this->getJname());
        $query = "SELECT usertitle FROM #__usergroup WHERE usergroupid = $groupid";
        $db->setQuery($query);
        $title = $db->loadResult();

        if (empty($title)) {
            $query = 'SELECT title FROM #__usertitle WHERE minposts <= ' . $posts . ' ORDER BY minposts DESC LIMIT 1';
            $db->setQuery($query);
            $title = $db->loadResult();
        }

        return $title;
    }

    function syncSessions($keealive = false)
    {
        $debug = (defined('DEBUG_SYSTEM_PLUGIN') ? true : false);
        if ($debug) {
            JError::raiseNotice('500', 'vbulletin keep alive called');
        }
        $options = array();
        //retrieve the values for vb's cookies
        $cookie_prefix = $this->params->get('cookie_prefix');
        $vbversion = & $this->helper->getVersion();
        if ((int) substr($vbversion, 0, 1) > 3) {
           if (substr($cookie_prefix, -1) !== '_') {
               $cookie_prefix .= '_';
           }
        }
        $cookie_sessionhash = JRequest::getVar($cookie_prefix . 'sessionhash', '', 'cookie');
        $cookie_userid = JRequest::getVar($cookie_prefix . 'userid', '', 'cookie');
        $cookie_password = JRequest::getVar($cookie_prefix . 'password', '', 'cookie');
        $JUser = & JFactory::getUser();
        if (JPluginHelper::isEnabled ( 'system', 'remember' )) {
            jimport('joomla.utilities.utility');
            $hash = JUtility::getHash('JLOGIN_REMEMBER');
            $joomla_persistant_cookie = JRequest::getString($hash, '', 'cookie', JREQUEST_ALLOWRAW | JREQUEST_NOTRIM);
        } else {
            $joomla_persistant_cookie = '';
        }
        $db =& JFusionFactory::getDatabase($this->getJname());
        $query = "SELECT userid FROM #__session WHERE sessionhash = " . $db->Quote($cookie_sessionhash);
        $db->setQuery($query);
        $session_userid = $db->loadResult();

        if (!$JUser->get('guest', true)) {
            //user logged into Joomla so let's check for an active vb session
            if ($debug) {
                JError::raiseNotice('500', 'Joomla user logged in');
            }

            //find the userid attached to Joomla's userid
            $joomla_userid = $JUser->get('id');
            $userlookup = JFusionFunction::lookupUser($this->getJname(), $joomla_userid);
            $vb_userid = (!empty($userlookup)) ? $userlookup->userid : 0;

            //check to see if the userid/password cookies are empty or if the session userid does not match an existing user in vB
            if ((!empty($keepalive) || !empty($joomla_persistant_cookie)) && ((empty($cookie_userid) && empty($cookie_password)) || (!empty($session_userid) && $session_userid != $vb_userid))) {
                if ($debug) {
                    JError::raiseNotice('500', 'vbulletin guest');
                    JError::raiseNotice('500', "cookie_sessionhash = $cookie_sessionhash");
                    JError::raiseNotice('500', "session_userid = $session_userid");
                    JError::raiseNotice('500', "vb_userid = $vb_userid");
                }
                //enable remember me as this is a keep alive function anyway
                $options['remember'] = 1;
                //get the user's info
                $query = "SELECT username, email FROM #__user WHERE userid = {$userlookup->userid}";
                $db->setQuery($query);
                $user_identifiers = $db->loadObject();
                $userinfo = $this->getUser($user_identifiers);
                //create a new session
                $status = $this->createSession($userinfo, $options);
                if ($debug) {
                    JFusionFunction::raiseWarning('500', $status);
                }
                //signal that session was changed
                return 1;
            } else {
               if ($debug) {
                    JError::raiseNotice('500','keep alive disabled or no persistant session found so calling Joomla\'s destorySession');
                }
                $JoomlaUser = JFusionFactory::getUser('joomla_int');
                $userinfo  = (array) $JUser;
                $options['clientid'][] = '0';
                $status = $JoomlaUser->destroySession($userinfo, $options);
                if ($debug) {
                    JFusionFunction::raiseWarning('500',$status);
                }
            }
        } elseif (!empty($session_userid)) {
            //the user is not logged into Joomla and we have an active vB session

           if ($debug) {
                JError::raiseNotice('500','Joomla has a guest session');
            }

            //find the Joomla user id attached to the vB user
            $userlookup = JFusionFunction::lookupUser($this->getJname(), $session_userid, false);

            if (!empty($joomla_persistant_cookie)) {
               if ($debug) {
                    JError::raiseNotice('500','Joomla persistant cookie found so let Joomla handle renewal');
                }
                return 0;
            } elseif (empty($keepalive)) {
               if ($debug) {
                    JError::raiseNotice('500','Keep alive disabled so kill vBs session');
                }
                //something fishy or user chose not to use remember me so let's destroy vB's session
                $cookie_prefix = $this->params->get('cookie_prefix');
                $vbversion = & $this->helper->getVersion();
                if ((int) substr($vbversion, 0, 1) > 3) {
                   if (substr($cookie_prefix, -1) !== '_') {
                       $cookie_prefix .= '_';
                   }
                }
                $cookie_domain = $this->params->get('cookie_domain');
                $cookie_path = $this->params->get('cookie_path');
                $cookie_salt = $this->params->get('cookie_salt');
                $secure = $this->params->get('secure',false);
                $httponly = $this->params->get('httponly',true);
                $time = time() - 3600;
                require_once JPATH_ADMINISTRATOR .DS.'components'.DS.'com_jfusion'.DS.'models'.DS.'model.curl.php';
                JFusionCurl::addCookie($cookie_prefix.'userid' , 0, $time, $cookie_path, $cookie_domain, $secure, $httponly);
                JFusionCurl::addCookie($cookie_prefix.'password' , 0, $time, $cookie_path, $cookie_domain, $secure, $httponly);
                JFusionCurl::addCookie($cookie_prefix.'sessionhash' , 0, $time, $cookie_path, $cookie_domain, $secure, $httponly);
                return 1;
            } elseif ($debug) {
                JError::raiseNotice('500','Keep alive enabled so renew Joomla\'s session');
            }

            if (!empty($userlookup)) {
               if ($debug) {
                    JError::raiseNotice('500','Found a phpBB user so attempting to renew Joomla\'s session.');
                }
                //get the user's info
                $db = & JFactory::getDBO();
                $query = "SELECT username, email FROM #__users WHERE id = {$userlookup->id}";
                $db->setQuery($query);
                $user_identifiers = $db->loadObject();
                $JoomlaUser = JFusionFactory::getUser('joomla_int');
                $userinfo = $JoomlaUser->getUser($user_identifiers);
                if (!empty($userinfo)) {
                    global $JFusionActivePlugin;
                    $JFusionActivePlugin = $this->getJname();
                    $status = $JoomlaUser->createSession($userinfo, $options);
                    if ($debug) {
                        JFusionFunction::raiseWarning('500',$status);
                    }
                    //no need to signal refresh as Joomla will recognize this anyway
                    return 0;
                }
            }
        }
    }

    /**
     * AEC Integration Functions
     */

    function AEC_Settings(&$current_settings)
    {
        $settings = array();
        $settings['vb_notice'] = array('fieldset', 'vB - Notice', 'If it is not enabled below to update a user\'s group upon a plan expiration or subscription, JFusion will use vB\'s advanced group mode setting if enabled to update the group.  Otherwise the user\'s group will not be touched.');
        $settings['vb_block_user'] = array('list_yesno', 'vB - Ban User on Expiration', 'Ban the user in vBulletin on a plan\'s expiration.');
        $settings['vb_block_reason'] = array('inputE', 'vB - Ban Reason', 'Message displayed as the reason the user has been banned.');
        $settings['vb_update_expiration_group'] = array('list_yesno', 'vB - Update Group on Expiration', 'Updates the user\'s usergroup in vB on a plan\'s expiration.');
        $settings['vb_expiration_groupid'] = array('list', 'vB - Expiration Group', 'Group to move the user into upon expiration.');
        $settings['vb_unblock_user'] = array('list_yesno', 'vB - Unban User on Subscription', 'Unbans the user in vBulletin on a plan\'s subscription.');
        $settings['vb_update_subscription_group'] = array('list_yesno', 'vB - Update Group on Subscription', 'Updates the user\'s usergroup in vB on a plan\'s subscription.');
        $settings['vb_subscription_groupid'] = array('list', 'vB - Subscription Group', 'Group to move the user into upon a subscription.');
        $settings['vb_block_user_registration'] = array('list_yesno', 'vB - Ban User on Registration', 'Ban the user in vBulletin when a user registers.  This ensures they do not have access to vB until they subscribe to a plan.');
        $settings['vb_block_reason_registration'] = array('inputE', 'vB - Registration Ban Reason', 'Message displayed as the reason the user has been banned.');

        $admin = & JFusionFactory::getAdmin($this->getJname());
        $usergroups = $admin->getUsergroupList();
        array_unshift($usergroups, JHTML::_('select.option', '0', '- Select a Group -', 'id', 'name'));
        $v = (isset($current_settings['vb_expiration_groupid'])) ? $current_settings['vb_expiration_groupid'] : '';
        $settings['lists']['vb_expiration_groupid'] = JHTML::_('select.genericlist', $usergroups,  'vb_expiration_groupid', '', 'id', 'name', $v);
        $v = (isset($current_settings['vb_subscription_groupid'])) ? $current_settings['vb_subscription_groupid'] : '';
        $settings['lists']['vb_subscription_groupid'] = JHTML::_('select.genericlist', $usergroups,  'vb_subscription_groupid', '', 'id', 'name', $v);
        return $settings;
    }

    function AEC_expiration_action(&$settings, &$request, $userinfo)
    {
        $status = array();
        $status['error'] = array();
        $status['debug'] = array();
        $status['aec'] = 1;
        $status['block_message'] = $settings['vb_block_reason'];

        $existinguser = $this->getUser($userinfo);
        if (!empty($existinguser)) {
            if ($settings['vb_block_user']) {
                $userinfo->block =  1;
                $this->blockUser($userinfo, $existinguser, $status);
            }

            if ($settings['vb_update_expiration_group'] && !empty($settings['vb_expiration_groupid'])) {
                //backup Joomla's global scope
                $this->helper->backupJoomla();

                //initialize vb framework
                if (!$this->helper->vBulletinInit()) {
                    return null;
                }

                //setup the existing user
                $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
                $vbuserinfo = $this->helper->convertUserData($existinguser);
                $userdm->set_existing($vbuserinfo);

                $userdm->set('usergroupid', $settings['vb_expiration_groupid']);
                $userdm->set('membergroupids', $settings['vb_expiration_groupid']);

                $usertitle = $this->getDefaultUserTitle($settings['vb_expiration_groupid']);
                $userdm->set('usertitle',$usertitle);

                //performs some final VB checks before saving
                $userdm->pre_save();
                if (empty($userdm->errors)) {
                    $userdm->save();

                    //now save the displaygroup
                    unset($userdm);
                    $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
                    $userdm->set_existing($vbuserinfo);
                    $userdm->set('displaygroupid', $settings['vb_expiration_groupid']);
                    $userdm->pre_save();
                    if (empty($userdm->errors)) {
                        $userdm->save();
                    } else {
                        foreach ($userdm->errors AS $index => $error) {
                            $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . $error;
                        }
                    }

                    $status['debug'][] = JText::_('GROUP_UPDATE'). ': ' . $existinguser->group_id . ' -> ' . $settings['vb_expiration_groupid'];
                } else {
                    foreach ($userdm->errors AS $index => $error) {
                        $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . $error;
                    }
                }

                unset($userdm);

                //restore Joomla's global scope
                $this->helper->restoreJoomla();
            } else {
                $this->updateUser($userinfo, 0);
            }
        }
    }

    function AEC_action(&$settings, &$request, $userinfo)
    {
        $status = array();
        $status['error'] = array();
        $status['debug'] = array();
        $status['aec'] = 1;

        $existinguser = $this->getUser($userinfo);
        if (!empty($existinguser)) {
            if ($settings['vb_unblock_user']) {
                $userinfo->block =  0;
                $this->unblockUser($userinfo, $existinguser, $status);
            }

            if ($settings['vb_update_subscription_group'] && !empty($settings['vb_subscription_groupid'])) {
                //backup Joomla's global scope
                $this->helper->backupJoomla();

                //initialize vb framework
                if (!$this->helper->vBulletinInit()) {
                    return null;
                }

                //setup the existing user
                $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
                $vbuserinfo = $this->helper->convertUserData($existinguser);
                $userdm->set_existing($vbuserinfo);

                $userdm->set('usergroupid', $settings['vb_subscription_groupid']);
                $userdm->set('membergroupids', $settings['vb_subscription_groupid']);

                $usertitle = $this->getDefaultUserTitle($settings['vb_subscription_groupid']);
                $userdm->set('usertitle',$usertitle);

                //performs some final VB checks before saving
                $userdm->pre_save();
                if (empty($userdm->errors)) {
                    $userdm->save();

                    //now save the displaygroup
                    unset($userdm);
                    $userdm =& datamanager_init('User', $this->helper->vb_data, ERRTYPE_SILENT);
                    $userdm->set_existing($vbuserinfo);
                    $userdm->set('displaygroupid', $settings['vb_subscription_groupid']);
                    $userdm->pre_save();
                    if (empty($userdm->errors)) {
                        $userdm->save();
                    } else {
                        foreach ($userdm->errors AS $index => $error) {
                            $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . $error;
                        }
                    }

                    $status['debug'][] = JText::_('GROUP_UPDATE'). ': ' . $existinguser->group_id . ' -> ' . $settings['vb_subscription_groupid'];
                } else {
                    foreach ($userdm->errors AS $index => $error) {
                        $status['error'][] = JText::_('GROUP_UPDATE_ERROR') . ' ' . $error;
                    }
                }

                unset($userdm);

                //restore Joomla's global scope
                $this->helper->restoreJoomla();
            } else {
                $this->updateUser($userinfo, 0);
            }
        }

        $mainframe = & JFactory::getApplication();
        if (!$mainframe->isAdmin()) {
            //login to vB
            $options = array();
            $options['remember'] = 1;
            $this->createSession($existinguser, $options);
        }
    }

    function AEC_on_userchange_action(&$settings, &$request, $userinfo)
    {
        //Only do something on registration
        if (strcmp($request->trace, 'registration') === 0) {
            $status = array();
            $status['error'] = array();
            $status['debug'] = array();
            $status['aec'] = 1;
            $status['block_message'] = $settings['vb_block_reason_registration'];
            $existinguser = $this->getUser($userinfo);
            if (!empty($existinguser)) {
                if ($settings['vb_block_user_registration']) {
                    $userinfo->block =  1;
                    $this->blockUser($userinfo, $existinguser, $status);
                }
            }
        }
    }
}