<?php

 /*
 * 
 * PHP version 5
 * 
 * @category   JFusion
 * @package    JFusionPlugins
 * @subpackage phpBB3
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */
 
// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * JFusion Authentication Class for phpBB3
 * For detailed descriptions on these functions please check the model.abstractauth.php
 * 
 * @category   JFusion
 * @package    JFusionPlugins
 * @subpackage phpBB3
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */
class JFusionAuth_phpbb3 extends JFusionAuth 
{
    /**
     * returns the name of this JFusion plugin
     * @return string name of current JFusion plugin
     */
    function getJname() 
    {
        return 'phpbb3';
    }
    function generateEncryptedPassword($userinfo) {
        // get the encryption PHP file
        if (!class_exists('PasswordHash')) {
            require_once JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'plugins' . DS . $this->getJname() . DS . 'PasswordHash.php';
        }
        $t_hasher = new PasswordHash(8, true);
        $check = $t_hasher->CheckPassword($userinfo->password_clear, $userinfo->password);
        //$check will be true or false if the passwords match
        unset($t_hasher);
        //cleanup
        if ($check) {
            //password is correct and return the phpbb3 password hash
            return $userinfo->password;
        } else {
            //no phpbb3 encryption used and return the phpbb2 password hash
            $encrypt_password = md5($userinfo->password_clear);
            return $encrypt_password;
        }
    }
}
