<?php

/**
 * This is the jfusion sql element file
 *
 * PHP version 5
 *
 * @category  JFusion
 * @package   Elements
 * @author    JFusion Team <webmaster@jfusion.org>
 * @copyright 2008 JFusion. All rights reserved.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link      http://www.jfusion.org
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();
/**
 * Require the Jfusion plugin factory
 */
require_once JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'model.factory.php';
require_once JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'model.jfusion.php';

/**
 * JFusion Element class sql
 *
 * @category  JFusion
 * @package   Elements
 * @author    JFusion Team <webmaster@jfusion.org>
 * @copyright 2008 JFusion. All rights reserved.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link      http://www.jfusion.org
 */
class JElementjfusionsql extends JElement
{
    var $_name = "jfusionsql";
    /**
     * Get an element
     *
     * @param string $name         name of element
     * @param string $value        value of element
     * @param string &$node        node of element
     * @param string $control_name name of controler
     *
     * @return string html
     */
    function fetchElement($name, $value, &$node, $control_name)
    {
        global $jname;
        if (!empty($jname)) {
            if (JFusionFunction::validPlugin($jname)) {
                $db = & JFusionFactory::getDatabase($jname);
                $db->setQuery($node->attributes('query'));
                if ($results = $db->loadObjectList()) {
                    $key = ($node->attributes('key_field')) ? $node->attributes('key_field') : 'value';
                    $val = ($node->attributes('value_field')) ? $node->attributes('value_field') : $name;
                    return JHTML::_('select.genericlist', $results, '' . $control_name . '[' . $name . ']', 'class="inputbox"', $key, $val, $value, $control_name . $name);
                } else {
                    return $db->stderr();
                }
            } else {
                return JText::_('SAVE_CONFIG_FIRST');
            }
        } else {
            return 'Programming error: You must define global $jname before the JParam object can be rendered';
        }
    }
}
