<?php

/**
 * First file that gets called for accessing jfusion in the administrator panel
 *
 * PHP version 5
 *
 * @category  JFusion
 * @package   ControllerAdmin
 * @author    JFusion Team <webmaster@jfusion.org>
 * @copyright 2008 JFusion. All rights reserved.
 * @license   http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link      http://www.jfusion.org
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
//check to see if PHP5 is used
if (version_compare(PHP_VERSION, '5.0.0', '<')) {
    //die if php4 is used
    die(JText::_('PHP_VERSION_OUTDATED') . PHP_VERSION . '<br/><br/>' . JText::_('PHP_VERSION_UPGRADE'));
}

//Load the language files of the plugins
$db = & JFactory::getDBO();
$query = 'SELECT name from #__jfusion';
$db->setQuery($query);
$plugins = $db->loadObjectList();
$lang = & JFactory::getLanguage();
foreach ($plugins as $plugin) {
    // Language file is loaded in function of the context
    // of the selected language in Joomla
    // and of the JPATH_BASE (in admin = JPATH_ADMINISTRATOR, in site = JPATH_SITE)
    $lang->load('com_jfusion.plg_' . $plugin->name);
}

//load the JFusion CSS and javascript
$document = & JFactory::getDocument();
$document->addStyleSheet('components/com_jfusion/css/jfusion.css');
$document->addScript('components/com_jfusion/js/jfusion.js');

/**
 * Require the base controller
 */
require_once JPATH_COMPONENT . DS . 'controllers' . DS . 'controller.jfusion.php';
// Require specific controller if requested
if ($controller = JRequest::getWord('controller')) {
    $path = JPATH_COMPONENT . DS . 'controllers' . DS . $controller . '.php';
    if (file_exists($path)) {
        include_once $path;
    } else {
        $controller = '';
    }
}
// Create the controller
$classname = 'JFusionController' . $controller;
$controller = new $classname();
// Perform the Request task
$task = JRequest::getVar('task');
if (!$task) {
    $task = 'cpanel';
}
$tasklist = $controller->getTasks();
if (in_array($task, $tasklist)) {
    //excute the task
    $controller->execute($task);
} else {
    //run the task as a view
    JRequest::setVar('view', $task);
    $controller->display();
}
// Redirect if set by the controller
$controller->redirect();
