/**
* @version 1.0.6
* @package PWebFBLikeBox
* @copyright © 2012 Majestic Media sp. z o.o., All rights reserved. http://www.perfect-web.co
* @license GNU General Public Licence http://www.gnu.org/licenses/gpl-3.0.html
* @author Piotr Moćko
*/
window.addEvent("domready", function(){	
	
	$("paramsfb_xmlns").setProperty('readonly', 'readonly');
	
	// validate int
	$$("#paramswidth, #paramsheight").addEvent("change", function() {
		if (this.value) {
			var value = parseInt(this.value);
			this.value = isNaN(value) ? '' : value;
		}
	});
	
	// validate unit
	$$("#paramstop").addEvent("change", function() {
		var regex = /^\d+(px|em|ex|cm|mm|in|pt|pc|%){1}$/i;
		if (!this.value || regex.test(this.value)) {
			this.removeClass('invalid');
		} else {
			var value = parseInt(this.value);
			if (!isNaN(value)) {
				this.value = value+'px';
				this.removeClass('invalid');
			} else {
				this.addClass('invalid');
			}
		}
	});
	
	// validate color
	$$("#paramsbackground, #paramsinset_background, #paramsborder_color").addEvent("change", function() {
		var regex = /^(\w|#[0-9a-f]{3}|#[0-9a-f]{6}|rgb\(\d{1,3},[ ]?\d{1,3},[ ]?\d{1,3}\)|rgba\(\d{1,3},[ ]?\d{1,3},[ ]?\d{1,3},[ ]?[0]?\.\d{1}\))$/i;
		if (!this.value || regex.test(this.value)) {
			this.removeClass('invalid');
		} else {
			this.addClass('invalid');
		}
	});
	
	// validate url & FB Page
	$("paramshref").addEvent("change", function() {
		var regex = /^((http|https):){0,1}\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/i;
		var url = decodeURI(this.value);
		this.value = encodeURI(url);
		if (!this.value || regex.test(this.value)) {
			this.removeClass('invalid');
			if (FB && this.value) {
				var segments = url.split('/');
				var page = segments[segments.length-1];
				
				FB.api(page, {fields: 'category'}, function(response) {
					if (!response || response.category) {
						$('paramshref').removeClass('invalid');
					}
					else {
						$('paramshref').addClass('invalid')
						if (response.error && response.error.code == 100) 
							alert('Given URL is not a Facebook Page');
					} 
				});
			}
		} else {
			this.addClass('invalid');
		}
	});
	
	$("jform_params_width").addEvent("change", function() {
		if (parseInt(this.value) < 292) alert(JText_MOD_PWEBFBLIKEBOX_WIDTH_MESSAGE);
	});
});

// load FB SDK 
(function(d,s,id){
var js,fjs=d.getElementsByTagName(s)[0];
if(d.getElementById(id))return;
js=d.createElement(s);js.id=id;
js.src="//connect.facebook.net/en_US/all.js";
fjs.parentNode.insertBefore(js,fjs);
}(document,"script","facebook-jssdk"));