CREATE TABLE IF NOT EXISTS `#__joomgallery` (
  `id` int(11) NOT NULL auto_increment,
  `catid` int(11) NOT NULL default '0',
  `imgtitle` text NOT NULL,
  `imgauthor` varchar(50) default NULL,
  `imgtext` text NOT NULL,
  `imgdate` varchar(20) default NULL,
  `imgcounter` int(11) NOT NULL default '0',
  `imgvotes` int(11) NOT NULL default '0',
  `imgvotesum` int(11) NOT NULL default '0',
  `published` tinyint(1) NOT NULL default '0',
  `imgfilename` varchar(100) NOT NULL default '',
  `imgthumbname` varchar(100) NOT NULL default '',
  `checked_out` int(11) NOT NULL default '0',
  `owner` int(11) UNSIGNED NOT NULL default '0',
  `approved` tinyint(1) NOT NULL default '0',
  `useruploaded` tinyint(1) NOT NULL default '0',
  `ordering` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX idx_catid (`catid`),
  INDEX idx_owner (`owner`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_catg` (
  `cid` int(11) NOT NULL auto_increment,
  `name` varchar(255) NOT NULL default '',
  `parent` int(11) NOT NULL default '0',
  `description` text,
  `ordering` int(11) NOT NULL default '0',
  `access` tinyint(3) unsigned NOT NULL default '0',
  `published` char(1) NOT NULL default '0',
  `owner` int(11) default NULL,
  `catimage` varchar(100),
  `img_position` int(10) default '0',
  `catpath` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`cid`),
  INDEX idx_parent (`parent`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_comments` (
  `cmtid` int(11) NOT NULL auto_increment,
  `cmtpic` int(11) NOT NULL default '0',
  `cmtip` varchar(15) NOT NULL default '',
  `userid` int(11) UNSIGNED NOT NULL default '0',
  `cmtname` varchar(50) NOT NULL default '',
  `cmttext` text NOT NULL,
  `cmtdate` varchar(20) default NULL,
  `published` tinyint(1) NOT NULL default '0',
  `approved` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`cmtid`),
  INDEX idx_cmtpic (`cmtpic`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_config` (
  `id` int(1) NOT NULL default '0',
  `jg_pathimages` varchar(50) NOT NULL,
  `jg_pathoriginalimages` varchar(50) NOT NULL,
  `jg_paththumbs` varchar(50) NOT NULL,
  `jg_pathftpupload` varchar(50) NOT NULL,
  `jg_pathtemp` varchar(50) NOT NULL,
  `jg_wmpath` varchar(50) NOT NULL,
  `jg_wmfile` varchar(50) NOT NULL,
  `jg_dateformat` varchar(50) NOT NULL,
  `jg_checkupdate` int(1) NOT NULL,
  `jg_filenamewithjs` int(1) NOT NULL,
  `jg_filenamesearch` varchar(50) NOT NULL,
  `jg_filenamereplace` varchar(50) NOT NULL,
  `jg_thumbcreation` varchar(5) NOT NULL,
  `jg_fastgd2thumbcreation` int(1) NOT NULL,
  `jg_impath` varchar(50) NOT NULL,
  `jg_resizetomaxwidth` int(1) NOT NULL,
  `jg_maxwidth` int(5) NOT NULL,
  `jg_picturequality` int(3) NOT NULL,
  `jg_useforresizedirection` int(1) NOT NULL,
  `jg_thumbwidth` int(5) NOT NULL,
  `jg_thumbheight` int(5) NOT NULL,
  `jg_thumbquality` int(3) NOT NULL,
  `jg_uploadorder` int(1) NOT NULL,
  `jg_useorigfilename` int(1) NOT NULL,
  `jg_filenamenumber` int(1) NOT NULL,
  `jg_delete_original` int(1) NOT NULL,
  `jg_wrongvaluecolor` varchar(10) NOT NULL,
  `jg_combuild` int(1) NOT NULL,
  `jg_realname` int(1) NOT NULL,
  `jg_bridge` int(1) NOT NULL,
  `jg_cooliris` int(1) NOT NULL,
  `jg_coolirislink` int(1) NOT NULL,
  `jg_userspace` int(1) NOT NULL,
  `jg_approve` int(1) NOT NULL,
  `jg_usercat` int(1) NOT NULL,
  `jg_maxusercat` int(5) NOT NULL,
  `jg_userowncatsupload` int(1) NOT NULL,
  `jg_maxuserimage` int(9) NOT NULL,
  `jg_maxfilesize` int(9) NOT NULL,
  `jg_category` text NOT NULL,
  `jg_usercategory` text NOT NULL,
  `jg_usercatacc` int(1) NOT NULL,
  `jg_maxuploadfields` int(3) NOT NULL,
  `jg_useruploadnumber` int(1) NOT NULL,
  `jg_special_gif_upload` int(1) NOT NULL,
  `jg_delete_original_user` int(1) NOT NULL,
  `jg_newpiccopyright` int(1) NOT NULL,
  `jg_newpicnote` int(1) NOT NULL,
  `jg_showrating` int(1) NOT NULL,
  `jg_maxvoting` int(1) NOT NULL,
  `jg_onlyreguservotes` int(1) NOT NULL,
  `jg_showcomment` int(1) NOT NULL,
  `jg_anoncomment` int(1) NOT NULL,
  `jg_namedanoncomment` int(1) NOT NULL,
  `jg_approvecom` int(1) NOT NULL,
  `jg_secimages` int(1) NOT NULL,
  `jg_bbcodesupport` int(1) NOT NULL,
  `jg_smiliesupport` int(1) NOT NULL,
  `jg_anismilie` int(1) NOT NULL,
  `jg_smiliescolor` varchar(10) NOT NULL,
  `jg_firstorder` varchar(20) NOT NULL,
  `jg_secondorder` varchar(20) NOT NULL,
  `jg_thirdorder` varchar(20) NOT NULL,
  `jg_pagetitle_cat` varchar(50) NOT NULL,
  `jg_pagetitle_detail` varchar(50) NOT NULL,
  `jg_showgalleryhead` int(1) NOT NULL,
  `jg_showpathway` int(1) NOT NULL,
  `jg_completebreadcrumbs` int(1) NOT NULL,
  `jg_search` int(1) NOT NULL,
  `jg_showallpics` int(1) NOT NULL,
  `jg_showallhits` int(1) NOT NULL,
  `jg_showbacklink` int(1) NOT NULL,
  `jg_suppresscredits` int(1) NOT NULL,
  `jg_showuserpanel` int(1) NOT NULL,
  `jg_showallpicstoadmin` int(1) NOT NULL,
  `jg_showminithumbs` int(1) NOT NULL,
  `jg_openjs_padding` int(3) NOT NULL,
  `jg_openjs_background` varchar(10) NOT NULL,
  `jg_dhtml_border` varchar(10) NOT NULL,
  `jg_show_title_in_dhtml` int(1) NOT NULL,
  `jg_show_description_in_dhtml` int(1) NOT NULL,
  `jg_lightbox_speed` int(3) NOT NULL,
  `jg_lightbox_slide_all` int(1) NOT NULL,
  `jg_resize_js_image` int(1) NOT NULL,
  `jg_disable_rightclick_original` int(1) NOT NULL,
  `jg_showgallerysubhead` int(1) NOT NULL,
  `jg_showallcathead` int(1) NOT NULL,
  `jg_colcat` int(1) NOT NULL,
  `jg_catperpage` int(1) NOT NULL,
  `jg_ordercatbyalpha` int(1) NOT NULL,
  `jg_showgallerypagenav` int(1) NOT NULL,
  `jg_showcatcount` int(1) NOT NULL,
  `jg_showcatthumb` int(1) NOT NULL,
  `jg_showrandomcatthumb` int(1) NOT NULL,
  `jg_ctalign` int(1) NOT NULL,
  `jg_showtotalcathits` int(1) NOT NULL,
  `jg_showcatasnew` int(1) NOT NULL,
  `jg_catdaysnew` int(3) NOT NULL,
  `jg_rmsm` int(1) NOT NULL,
  `jg_showrmsmcats` int(1) NOT NULL,
  `jg_showsubsingalleryview` int(1) NOT NULL,
  `jg_showcathead` int(1) NOT NULL,
  `jg_usercatorder` int(1) NOT NULL,
  `jg_usercatorderlist` varchar(50) NOT NULL,
  `jg_showcatdescriptionincat` int(1) NOT NULL,
  `jg_showpagenav` int(1) NOT NULL,
  `jg_showpiccount` int(1) NOT NULL,
  `jg_perpage` int(3) NOT NULL,
  `jg_catthumbalign` int(1) NOT NULL,
  `jg_colnumb` int(3) NOT NULL,
  `jg_detailpic_open` int(1) NOT NULL,
  `jg_lightboxbigpic` int(1) NOT NULL,
  `jg_showtitle` int(1) NOT NULL,
  `jg_showpicasnew` int(1) NOT NULL,
  `jg_daysnew` int(3) NOT NULL,
  `jg_showhits` int(1) NOT NULL,
  `jg_showauthor` int(1) NOT NULL,
  `jg_showowner` int(1) NOT NULL,
  `jg_showcatcom` int(1) NOT NULL,
  `jg_showcatrate` int(1) NOT NULL,
  `jg_showcatdescription` int(1) NOT NULL,
  `jg_showcategorydownload` int(1) NOT NULL,
  `jg_showcategoryfavourite` int(1) NOT NULL,
  `jg_showsubcathead` int(1) NOT NULL,
  `jg_showsubcatcount` int(1) NOT NULL,
  `jg_colsubcat` int(3) NOT NULL,
  `jg_subperpage` int(3) NOT NULL,
  `jg_showpagenavsubs` int(1) NOT NULL, 
  `jg_subcatthumbalign` int(1) NOT NULL,
  `jg_showsubthumbs` int(1) NOT NULL,
  `jg_showrandomsubthumb` int(1) NOT NULL,
  `jg_ordersubcatbyalpha` int(1) NOT NULL,
  `jg_showtotalsubcathits` int(1) NOT NULL,
  `jg_showdetailpage` int(1) NOT NULL,
  `jg_showdetailnumberofpics` int(1) NOT NULL,
  `jg_cursor_navigation` int(1) NOT NULL,
  `jg_disable_rightclick_detail` int(1) NOT NULL,
  `jg_showdetailtitle` int(1) NOT NULL,
  `jg_showdetail` int(1) NOT NULL,
  `jg_showdetailaccordion` int(1) NOT NULL,
  `jg_showdetaildescription` int(1) NOT NULL,
  `jg_showdetaildatum` int(1) NOT NULL,
  `jg_showdetailhits` int(1) NOT NULL,
  `jg_showdetailrating` int(1) NOT NULL,
  `jg_showdetailfilesize` int(1) NOT NULL,
  `jg_showdetailauthor` int(1) NOT NULL,
  `jg_showoriginalfilesize` int(1) NOT NULL,
  `jg_showdetaildownload` int(1) NOT NULL,
  `jg_downloadfile` int(1) NOT NULL,
  `jg_downloadwithwatermark` int(1) NOT NULL,
  `jg_watermark` int(1) NOT NULL,
  `jg_watermarkpos` int(1) NOT NULL,
  `jg_bigpic` int(1) NOT NULL,
  `jg_bigpic_open` int(1) NOT NULL,
  `jg_bbcodelink` int(1) NOT NULL,
  `jg_showcommentsunreg` int(1) NOT NULL,
  `jg_showcommentsarea` int(1) NOT NULL,
  `jg_send2friend` int(1) NOT NULL,
  `jg_minis` int(1) NOT NULL,
  `jg_motionminis` int(1) NOT NULL,
  `jg_motionminiWidth` int(3) NOT NULL,
  `jg_motionminiHeight` int(3) NOT NULL,
  `jg_miniWidth` int(3) NOT NULL,
  `jg_miniHeight` int(3) NOT NULL,
  `jg_minisprop` int(1) NOT NULL,
  `jg_nameshields` int(1) NOT NULL,
  `jg_nameshields_unreg` int(1) NOT NULL,
  `jg_show_nameshields_unreg` int(1) NOT NULL,
  `jg_nameshields_height` int(3) NOT NULL,
  `jg_nameshields_width` int(3) NOT NULL,
  `jg_slideshow` int(1) NOT NULL,
  `jg_slideshow_timer` int(3) NOT NULL,
  `jg_slideshow_usefilter` int(1) NOT NULL,
  `jg_slideshow_filterbychance` int(1) NOT NULL,
  `jg_slideshow_filtertimer` int(3) NOT NULL,
  `jg_showsliderepeater` int(1) NOT NULL,
  `jg_showexifdata` int(1) NOT NULL,
  `jg_subifdtags` text NOT NULL,
  `jg_ifdotags` text NOT NULL,
  `jg_gpstags` text NOT NULL,
  `jg_showiptcdata` int(1) NOT NULL,
  `jg_iptctags` text NOT NULL,
  `jg_showtoplist` int(1) NOT NULL,
  `jg_toplist` int(3) NOT NULL,
  `jg_topthumbalign` int(1) NOT NULL,
  `jg_toptextalign` int(1) NOT NULL,
  `jg_toplistcols` int(3) NOT NULL,
  `jg_whereshowtoplist` int(1) NOT NULL,
  `jg_showrate` int(1) NOT NULL,
  `jg_showlatest` int(1) NOT NULL,
  `jg_showcom` int(1) NOT NULL,
  `jg_showthiscomment` int(1) NOT NULL,
  `jg_showmostviewed` int(1) NOT NULL,
  `jg_favourites` int(1) NOT NULL,
  `jg_showdetailfavourite` int(1) NOT NULL,
  `jg_favouritesshownotauth` int(1) NOT NULL,
  `jg_maxfavourites` int(5) NOT NULL,
  `jg_zipdownload` int(1) NOT NULL,
  `jg_usefavouritesforpubliczip` int(1) NOT NULL,
  `jg_usefavouritesforzip` int(1) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_countstop` (
  `cspicid` int(11) NOT NULL default 0,
  `csip` varchar(20) NOT NULL ,
  `cssessionid` varchar(200) ,
  `cstime` DATETIME,
  INDEX idx_cspicid (`cspicid`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_nameshields` (
  `nid` int(11) NOT NULL auto_increment,
  `npicid` int(11) NOT NULL default '0',
  `nuserid` int(11) UNSIGNED NOT NULL default '0',
  `nxvalue` int(11) NOT NULL default '0',
  `nyvalue` int(11) NOT NULL default '0',
  `nuserip` varchar(15) NOT NULL default '0',
  `ndate` varchar(20) NOT NULL,
  `nzindex` int(11) NOT NULL default '0',
  PRIMARY KEY  (`nid`),
  INDEX idx_picid (`npicid`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_users` (
  `uid` int(11) NOT NULL auto_increment,
  `uuserid` int(11) NOT NULL default '0',
  `piclist` text default NULL,
  `layout` int(1) NOT NULL,
  `time` datetime NOT NULL,
  `zipname` varchar(70) NOT NULL,
  PRIMARY KEY  (`uid`),
  INDEX idx_uid (`uuserid`)
) ENGINE=MyISAM;

CREATE TABLE IF NOT EXISTS `#__joomgallery_votes` (
  `voteid` int(11) NOT NULL auto_increment,
  `picid` int(11) NOT NULL default '0',
  `userid` int(11) UNSIGNED NOT NULL default '0',
  `userip` varchar(15) NOT NULL default '0',
  `datevoted` varchar(20) NOT NULL,
  `timevoted` varchar(20) NOT NULL,
  `vote` int(11) NOT NULL default '0',
  PRIMARY KEY  (`voteid`),
  INDEX idx_picid (`picid`)
) ENGINE=MyISAM;

INSERT INTO `#__joomgallery_config` VALUES (
  /* id */ 0,
  /* ### General settings->path and directories ####*/  
  /*jg_pathimages*/         'components/com_joomgallery/img_pictures/',
  /*jg_pathoriginalimages*/ 'components/com_joomgallery/img_originals/',
  /*jg_paththumbs*/         'components/com_joomgallery/img_thumbnails/',
  /*jg_pathftpupload*/      'components/com_joomgallery/ftp_upload/',
  /*jg_pathtemp*/           'administrator/components/com_joomgallery/temp/',
  /*jg_wmpath*/             'components/com_joomgallery/assets/images/',
  /*jg_wmfile*/             'watermark.png',
  /*jg_dateformat*/         '%d.%m.%Y %H:%M:%S',
  /*jg_checkupdate*/        1,

  /* ### General settings->Replacements ####*/
  /*jg_filenamewithjs*/     1,
  /*jg_filenamesearch*/     'ä|ö|ü|ß',
  /*jg_filenamereplace*/    'ae|oe|ue|ss',

  /* ### General settings->Image Processing ####*/
  /*jg_thumbcreation*/          'gd2',
  /*jg_fastgd2thumbcreation*/   1,
  /*jg_impath*/                 '',
  /*jg_resizetomaxwidth*/       1,
  /*jg_maxwidth*/               400,
  /*jg_picturequality*/         100,
  /*jg_useforresizedirection*/  0,
  /*jg_thumbwidth*/             133,
  /*jg_thumbheight*/            100,
  /*jg_thumbquality*/           100,

  /* ### General settings->Backend Upload ####*/
  /*jg_uploadorder*/        1,
  /*jg_useorigfilename*/    0,
  /*jg_filenamenumber*/     1,
  /*jg_delete_original*/    0,
  /*jg_wrongvaluecolor*/    '#f00',

  /* ### General settings->Additional functions ####*/
  /*jg_combuild*/       0,
  /*jg_realname*/       0,
  /*jg_bridge*/         0,
  /*jg_cooliris*/       0,
  /*jg_coolirislink*/   0,

  /* ### User Access rights->User upload ####*/
  /*jg_userspace*/            1,
  /*jg_approve*/              0,
  /*jg_usercat*/              1,
  /*jg_maxusercat*/           10,
  /*jg_userowncatsupload*/    0,
  /*jg_maxuserimage*/         500,
  /*jg_maxfilesize*/          2000000,
  /*jg_category*/             '',
  /*jg_usercategory*/         '',
  /*jg_usercatacc*/           1,
  /*jg_maxuploadfields*/      3,
  /*jg_useruploadnumber*/     0,
  /*jg_special_gif_upload*/   1,
  /*jg_delete_original_user*/ 2,
  /*jg_newpiccopyright*/      1,
  /*jg_newpicnote*/           1,
  
  /* ### User Access rights->Rating ####*/
  /*jg_showrating*/       1,
  /*jg_maxvoting*/        5,
  /*jg_onlyreguservotes*/ 0,

  /* ### User Access rights->Comments ####*/
  /*jg_showcomment*/      1,
  /*jg_anoncomment*/      1,
  /*jg_namedanoncomment*/ 1,
  /*jg_approvecom*/       1,
  /*jg_secimages*/        0,
  /*jg_bbcodesupport*/    1,
  /*jg_smiliesupport*/    1,
  /*jg_anismilie*/        0,
  /*jg_smiliescolor*/     'grey',

  /* ### Frontend Settings->Picture Ordering ####*/
  /*jg_firstorder*/   'ordering ASC',
  /*jg_secondorder*/  'imgdate DESC',
  /*jg_thirdorder*/   'imgtitle DESC',

  /* ### Frontend Settings->Page Title ####*/
  /*jg_pagetitle_cat*/    '[! JGS_CATEGORY!]: #cat',
  /*jg_pagetitle_detail*/ '[! JGS_CATEGORY!]: #cat - [! JGS_PICTURE!]:  #img',
  
  /* ### Frontend Settings->Header and Footer ####*/  
  /*jg_showgalleryhead*/      1,
  /*jg_showpathway*/          1,
  /*jg_completebreadcrumbs*/  0,
  /*jg_search*/               0,
  /*jg_showallpics*/          3,
  /*jg_showallhits*/          1,
  /*jg_showbacklink*/         3,
  /*jg_suppresscredits*/      1,

  /* ### Frontend Settings->User Panel ####*/
  /*jg_showuserpanel*/      3,
  /*jg_showallpicstoadmin*/ 1,
  /*jg_showminithumbs*/     1,
  
  /* ### Frontend Settings->Popup Functions ####*/    
  /*jg_openjs_padding*/               10,
  /*jg_openjs_background*/            '#fff',
  /*jg_dhtml_border*/                 '#808080',
  /*jg_show_title_in_dhtml*/          0,
  /*jg_show_description_in_dhtml*/    1,
  /*jg_lightbox_speed*/               5,
  /*jg_lightbox_slide_all*/           1,
  /*jg_resize_js_image*/              1,
  /*jg_disable_rightclick_original*/  1,

  /* ### Gallery View->General Settings ####*/
  /*jg_showgallerysubhead*/           1,
  /*jg_showallcathead*/               1,
  /*jg_colcat*/                       4,
  /*jg_catperpage*/                   5,
  /*jg_ordercatbyalpha*/              0,
  /*jg_showgallerypagenav*/           1,
  /*jg_showcatcount*/                 1,
  /*jg_showcatthumb*/                 1,
  /*jg_showrandomcatthumb*/           3,
  /*jg_ctalign*/                      1,
  /*jg_showtotalcathits*/             1,
  /*jg_showcatasnew*/                 1,
  /*jg_catdaysnew*/                   7,
  /*jg_rmsm*/                         1,
  /*jg_showrmsmcats*/                 1,
  /*jg_showsubsingalleryview*/        0,

  /* ### Category View->General Settings ####*/
  /*jg_showcathead*/              1,
  /*jg_usercatorder*/             1,
  /*jg_usercatorderlist*/         'date,title',
  /*jg_showcatdescriptionincat*/  1,
  /*jg_showpagenav*/              2,
  /*jg_showpiccount*/             1,
  /*jg_perpage*/                  8,
  /*jg_catthumbalign*/            1,
  /*jg_colnumb*/                  2,
  /*jg_detailpic_open*/           0,
  /*jg_lightboxbigpic*/           1,
  /*jg_showtitle*/                1,
  /*jg_showpicasnew*/             1,
  /*jg_daysnew*/                  10,
  /*jg_showhits*/                 1,
  /*jg_showauthor*/               1,
  /*jg_showowner*/                1,
  /*jg_showcatcom*/               1,
  /*jg_showcatrate*/              1,
  /*jg_showcatdescription*/       1,
  /*jg_showcategorydownload*/     0,
  /*jg_showcategoryfavourite*/    0,
  
  /* ### Category View->Sub-Categories ####*/
  /*jg_showsubcathead*/       1,
  /*jg_showsubcatcount*/      1,
  /*jg_colsubcat*/            2,
  /*jg_subperpage*/           4,
  /*jg_showpagenavsubs*/      1,
  /*jg_subcatthumbalign*/     3,
  /*jg_showsubthumbs*/        2,
  /*jg_showrandomsubthumb*/   1,
  /*jg_ordersubcatbyalpha*/   0,
  /*jg_showtotalsubcathits*/  1,

  /* ### Detail View->General Settings ####*/
  /*jg_showdetailpage*/             1,
  /*jg_showdetailnumberofpics*/     1,
  /*jg_cursor_navigation*/          1,
  /*jg_disable_rightclick_detail*/  0,
  /*jg_showdetailtitle*/            1,   
  /*jg_showdetail*/                 1,
  /*jg_showdetailaccordion*/        0,
  /*jg_showdetaildescription*/      1,
  /*jg_showdetaildatum*/            1,
  /*jg_showdetailhits*/             1,
  /*jg_showdetailrating*/           1,
  /*jg_showdetailfilesize*/         1,
  /*jg_showdetailauthor*/           1,
  /*jg_showoriginalfilesize*/       1,
  /*jg_showdetaildownload*/         1,
  /*jg_downloadfile*/               2,
  /*jg_downloadwithwatermark*/      1,
  /*jg_watermark*/                  0,
  /*jg_watermarkpos*/               9,
  /*jg_bigpic*/                     2,
  /*jg_bigpic_open*/                6,
  /*jg_bbcodelink*/                 3,
  /*jg_showcommentsunreg*/          1,
  /*jg_showcommentsarea*/           2,
  /*jg_send2friend*/                1,
  
  /* ### Detail View->Motiongallery ####*/  
  /*jg_minis*/            1,
  /*jg_motionminis*/      2,
  /*jg_motionminiWidth*/  400,
  /*jg_motionminiHeight*/ 50,
  /*jg_miniWidth*/        28,
  /*jg_miniHeight*/       28,
  /*jg_minisprop*/        2,

  /* ### Detail View->Nametags ####*/  
  /*jg_nameshields*/            0,
  /*jg_nameshields_unreg*/      0,
  /*jg_show_nameshields_unreg*/ 0,
  /*jg_nameshields_height*/     10,
  /*jg_nameshields_width*/      6,

  /* ### Detail View->Slideshow Settings ####*/  
  /*jg_slideshow*/                1,
  /*jg_slideshow_timer*/          3,
  /*jg_slideshow_usefilter*/      1,
  /*jg_slideshow_filterbychance*/ 0,
  /*jg_slideshow_filtertimer*/    1,
  /*jg_showsliderepeater*/        0,

  /* ### Detail View->Exif data ####*/  
  /*jg_showexifdata*/   0,
  /*jg_subifdtags*/     '',
  /*jg_ifdotags*/       '',
  /*jg_gpstags*/        '',

  /* ### Detail View->IPTC data ####*/  
  /*jg_showiptcdata*/   0,
  /*jg_iptctags*/       '',
  
  /* ### Toplists ####*/  
  /*jg_showtoplist*/        2,
  /*jg_toplist*/            12,
  /*jg_topthumbalign*/      1,
  /*jg_toptextalign*/       1,
  /*jg_toplistcols*/        1,
  /*jg_whereshowtoplist*/   0,
  /*jg_showrate*/           1,
  /*jg_showlatest*/         1,
  /*jg_showcom*/            1,
  /*jg_showthiscomment*/    1,
  /*jg_showmostviewed*/     1,
  
  /* ### Favorites ####*/  
  /*jg_favourites*/                 0,
  /*jg_showdetailfavourite*/        0,
  /*jg_favouritesshownotauth*/      0,
  /*jg_maxfavourites*/              0,
  /*jg_zipdownload*/                0,
  /*jg_usefavouritesforpubliczip*/  0,
  /*jg_usefavouritesforzip*/        0
  );
