/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.swing.JProgressBar;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.gui.filepanel.SizeRenderer;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FilePreparationThread;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.FileUploadThreadFTP;
import wjhk.jupload2.upload.FileUploadThreadHTTP;
import wjhk.jupload2.upload.PacketConstructionThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadManagerThread
extends Thread {
    public static final int UPLOAD_STATUS_NOT_STARTED = 1;
    public static final int UPLOAD_STATUS_UPLOADING = 2;
    public static final int UPLOAD_STATUS_CHUNK_UPLOADED_WAITING_FOR_RESPONSE = 3;
    public static final int UPLOAD_STATUS_FILE_UPLOADED_WAITING_FOR_RESPONSE = 4;
    public static final int UPLOAD_STATUS_UPLOADED = 5;
    long currentRequestStartTime = 0L;
    FilePanel filePanel = null;
    FilePreparationThread filePreparationThread = null;
    PacketConstructionThread packetConstructionThread = null;
    FileUploadThread fileUploadThread = null;
    UploadFileData fileBeingUploaded = null;
    long globalStartTime = 0L;
    long maxChunkSize = -1L;
    int nbFilesPerRequest = -1;
    int nbSentFiles = 0;
    int nbSuccessfullyUploadedFiles = 0;
    long nbBytesUploadedForCurrentFile = 0L;
    int uploadStatus = 1;
    JProgressBar preparationProgressBar = null;
    JProgressBar uploadProgressBar = null;
    boolean uploadFinished = false;
    boolean stop = false;
    JUploadException uploadException = null;
    long uploadDuration = 0L;
    long nbUploadedBytes = 0L;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;

    public FileUploadManagerThread(UploadPolicy uploadPolicy) throws JUploadException {
        super("FileUploadManagerThread thread");
        this.constructor(uploadPolicy, null);
    }

    FileUploadManagerThread(UploadPolicy uploadPolicy, FileUploadThread fileUploadThreadParam) throws JUploadException {
        super("FileUploadManagerThread test thread");
        this.constructor(uploadPolicy, fileUploadThreadParam);
    }

    private synchronized void constructor(UploadPolicy uploadPolicy, FileUploadThread fileUploadThreadParam) throws JUploadException {
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPolicy.getContext().getUploadPanel();
        this.filePanel = this.uploadPanel.getFilePanel();
        this.uploadProgressBar = this.uploadPanel.getUploadProgressBar();
        this.preparationProgressBar = this.uploadPanel.getPreparationProgressBar();
        this.nbFilesPerRequest = this.uploadPolicy.getNbFilesPerRequest();
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        ArrayBlockingQueue<UploadFileData> preparedFileQueue = new ArrayBlockingQueue<UploadFileData>(this.filePanel.getFilesLength());
        BlockingQueue<UploadFilePacket> packetQueue = fileUploadThreadParam == null ? new ArrayBlockingQueue<UploadFilePacket>(this.filePanel.getFilesLength()) : fileUploadThreadParam.getPacketQueue();
        this.filePreparationThread = new FilePreparationThread(preparedFileQueue, this, this.uploadPolicy);
        this.packetConstructionThread = new PacketConstructionThread(preparedFileQueue, packetQueue, this, this.uploadPolicy);
        this.createUploadThread(packetQueue, fileUploadThreadParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.uploadPolicy.displayDebug("Start of the FileUploadManagerThread", 5);
            this.filePreparationThread.start();
            this.packetConstructionThread.start();
            this.fileUploadThread.start();
            this.uploadPolicy.beforeUpload();
            this.uploadPanel.updateButtonState();
            this.initProgressBar();
            while (this.fileUploadThread.isAlive() && !this.isUploadFinished()) {
                try {
                    this.uploadPolicy.displayDebug("Waiting for fileUploadThread to die", 10);
                    this.fileUploadThread.join();
                }
                catch (InterruptedException e) {
                    this.uploadPolicy.displayWarn("An InterruptedException occured in FileUploadManagerThread.run()");
                }
            }
            FileData[] fileDataArray = this.uploadPanel.getFilePanel().getFiles();
            for (int i = 0; i < fileDataArray.length; ++i) {
                if (!fileDataArray[i].isPreparedForUpload()) continue;
                fileDataArray[i].afterUpload();
            }
            this.uploadPanel.updateButtonState();
            this.uploadPolicy.getContext().showStatus("");
            this.uploadPolicy.getContext().getUploadPanel().getStatusLabel().setText("");
            if (this.getUploadException() != null) {
                this.uploadPolicy.sendDebugInformation("Error in Upload", this.getUploadException());
            } else if (this.isUploadStopped()) {
                this.uploadPolicy.displayInfo("Upload stopped by the user. " + this.nbSuccessfullyUploadedFiles + " file(s) uploaded in " + (int)((System.currentTimeMillis() - this.globalStartTime) / 1000L) + " seconds. Average upload speed: " + (this.uploadDuration > 0L ? (int)(this.nbUploadedBytes / this.uploadDuration) : 0) + " (kbytes/s)");
            } else {
                this.uploadPolicy.displayInfo("Upload finished normally. " + this.nbSuccessfullyUploadedFiles + " file(s) uploaded in " + (int)((System.currentTimeMillis() - this.globalStartTime) / 1000L) + " seconds. Average upload speed: " + (this.uploadDuration > 0L ? (int)(this.nbUploadedBytes / this.uploadDuration) : 0) + " (kbytes/s)");
                try {
                    this.uploadPolicy.afterUpload(this.getUploadException(), this.fileUploadThread.getResponseMsg());
                }
                catch (JUploadException e1) {
                    this.uploadPolicy.displayErr("error in uploadPolicy.afterUpload (JUploadPanel)", e1);
                }
            }
            if (!this.isUploadStopped() && this.getUploadException() != null) {
                try {
                    FileUploadManagerThread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.preparationProgressBar.setValue(0);
            this.preparationProgressBar.setString("");
            this.uploadProgressBar.setValue(0);
            this.uploadProgressBar.setString("");
            this.uploadPolicy.displayDebug("End of the FileUploadManagerThread", 5);
        }
        catch (Exception e) {
            JUploadException jue = e instanceof JUploadException ? (JUploadException)e : new JUploadException(e);
            this.setUploadException(jue);
            this.stopUpload();
        }
        finally {
            this.uploadPanel.updateButtonState();
        }
    }

    public int getNbUploadedFiles() {
        return this.nbSentFiles;
    }

    public synchronized void setUploadException(JUploadException uploadException) {
        if (this.uploadException != null) {
            this.uploadPolicy.displayWarn("An exception has already been set in FileUploadManagerThread. The next one is just logged.");
        } else {
            this.uploadException = uploadException;
        }
        this.preparationProgressBar.setString(uploadException.getMessage());
        String msg = this.uploadPolicy.getLocalizedString("errorDuringUpload", uploadException.getMessage());
        int userResponse = this.uploadPolicy.displayErr(msg, uploadException, 0);
        if (userResponse == 1) {
            this.uploadFinished = true;
        }
    }

    public JUploadException getUploadException() {
        return this.uploadException;
    }

    public boolean isUploadFinished() {
        return this.uploadFinished || this.stop;
    }

    private boolean isUploadStopped() {
        return this.stop;
    }

    public synchronized void nbBytesUploaded(long nbBytes) throws JUploadException {
        this.nbUploadedBytes += nbBytes;
        this.nbBytesUploadedForCurrentFile += nbBytes;
    }

    public synchronized void setUploadStatus(UploadFilePacket uploadFilePacket, UploadFileData uploadFileData, int uploadStatus) throws JUploadException {
        this.fileBeingUploaded = uploadFileData;
        if (this.globalStartTime == 0L) {
            this.globalStartTime = System.currentTimeMillis();
        }
        switch (uploadStatus) {
            case 3: 
            case 4: {
                this.uploadDuration += System.currentTimeMillis() - this.currentRequestStartTime;
                this.currentRequestStartTime = 0L;
                break;
            }
            case 2: {
                if (this.currentRequestStartTime != 0L) break;
                this.currentRequestStartTime = System.currentTimeMillis();
                break;
            }
            case 5: {
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown value for uploadStatus: " + uploadStatus);
            }
        }
        this.uploadStatus = uploadStatus;
        this.updateUploadProgressBar(uploadFilePacket, uploadFileData);
    }

    public synchronized void stopUpload() {
        this.stop = true;
        this.uploadFinished = true;
        if (this.fileUploadThread != null) {
            this.fileUploadThread.interrupt();
        }
    }

    private void updateUploadStatusBar() {
        if (null != this.uploadPanel.getStatusLabel() && this.nbUploadedBytes > 0L) {
            String eta;
            double globalCPS;
            double uploadSpeed;
            double percent;
            long actualUploadDuration = this.currentRequestStartTime == 0L ? this.uploadDuration : this.uploadDuration + System.currentTimeMillis() - this.currentRequestStartTime;
            actualUploadDuration /= 1000L;
            try {
                percent = 100.0 * (double)this.nbUploadedBytes / this.filePreparationThread.getTotalFileBytesToSend();
            }
            catch (ArithmeticException e1) {
                percent = 100.0;
            }
            try {
                uploadSpeed = (double)this.nbUploadedBytes / (double)actualUploadDuration;
            }
            catch (ArithmeticException e1) {
                uploadSpeed = this.nbUploadedBytes;
            }
            try {
                globalCPS = (double)this.nbUploadedBytes / (double)(System.currentTimeMillis() - this.globalStartTime) * 1000.0;
            }
            catch (ArithmeticException e1) {
                globalCPS = this.nbUploadedBytes;
            }
            try {
                long remaining = (long)((this.filePreparationThread.getTotalFileBytesToSend() - (double)this.nbUploadedBytes) / globalCPS);
                eta = remaining > 3600L ? this.uploadPolicy.getLocalizedString("timefmt_hms", remaining / 3600L, remaining / 60L % 60L, remaining % 60L) : (remaining > 60L ? this.uploadPolicy.getLocalizedString("timefmt_ms", remaining / 60L, remaining % 60L) : this.uploadPolicy.getLocalizedString("timefmt_s", remaining));
            }
            catch (ArithmeticException e1) {
                eta = this.uploadPolicy.getLocalizedString("timefmt_unknown", new Object[0]);
            }
            String status = this.uploadPolicy.getLocalizedString("status_msg", (int)percent, SizeRenderer.formatFileUploadSpeed(uploadSpeed, this.uploadPolicy), eta);
            this.uploadPanel.getStatusLabel().setText(status);
            this.uploadPolicy.getContext().showStatus(status);
        }
    }

    public synchronized void anotherFileHasBeenSent(UploadFilePacket uploadFilePacket, UploadFileData newlyUploadedFileData) throws JUploadException {
        ++this.nbSentFiles;
        this.nbBytesUploadedForCurrentFile = 0L;
        this.uploadPolicy.displayDebug(this.getClass().getName() + ".anotherFileHasBeenSent(): before call to newlyUploadedFileData.getUploadLength()", 100);
        this.uploadStatus = 5;
        this.updateUploadProgressBar(uploadFilePacket, newlyUploadedFileData);
    }

    public synchronized void currentRequestIsFinished(UploadFilePacket packet) throws JUploadException {
        this.setUploadStatus(packet, (UploadFileData)packet.get(packet.size() - 1), 5);
        for (UploadFileData fileData : packet) {
            this.filePanel.remove(fileData);
            ++this.nbSuccessfullyUploadedFiles;
        }
        if (!this.uploadFinished) {
            this.uploadFinished = this.nbSuccessfullyUploadedFiles == this.filePreparationThread.getNbFilesToSent();
        }
    }

    private void updateUploadProgressBar(UploadFilePacket lastUploadedFilePacket, UploadFileData lastUploadedFileData) {
        int percent = 0;
        if (this.nbBytesUploadedForCurrentFile == 0L || this.nbSentFiles == this.filePreparationThread.getNbFilesToSent()) {
            percent = 0;
        } else if (lastUploadedFileData == null) {
            percent = 0;
        } else {
            percent = (int)(this.nbBytesUploadedForCurrentFile * 100L / lastUploadedFileData.getUploadLength());
            if (percent > 100) {
                this.uploadPolicy.displayWarn("percent is more than 100 (" + percent + ") in FileUploadManagerThread.update.UploadProgressBar");
                percent = 100;
            }
        }
        this.uploadProgressBar.setValue(100 * this.nbSentFiles + percent);
        String msg = null;
        switch (this.uploadStatus) {
            case 1: {
                msg = "";
                break;
            }
            case 2: 
            case 3: {
                msg = this.uploadPolicy.getLocalizedString("infoUploading", this.nbSentFiles + 1);
                break;
            }
            case 4: {
                msg = lastUploadedFilePacket.size() == 1 ? lastUploadedFileData.getNumOfFileInCurrentRequest() + "/" + this.filePreparationThread.getNbFilesToSent() : ((UploadFileData)lastUploadedFilePacket.get(0)).getNumOfFileInCurrentRequest() + 1 + "-" + lastUploadedFileData.getNumOfFileInCurrentRequest() + "/" + this.filePreparationThread.getNbFilesToSent();
                msg = this.uploadPolicy.getLocalizedString("infoUploaded", msg);
                break;
            }
            case 5: {
                msg = this.uploadPolicy.getLocalizedString("nbUploadedFiles", this.nbSentFiles);
                break;
            }
            default: {
                this.uploadPolicy.displayWarn("Unknown upload status in FileUploadManagerThread.updateProgressBar(): " + this.uploadStatus);
            }
        }
        this.uploadProgressBar.setString(msg);
        this.uploadProgressBar.repaint();
    }

    private synchronized void createUploadThread(BlockingQueue<UploadFilePacket> packetQueue, FileUploadThread fileUploadThreadParam) throws JUploadException {
        if (fileUploadThreadParam != null) {
            this.fileUploadThread = fileUploadThreadParam;
            fileUploadThreadParam.setFileUploadThreadManager(this);
        } else {
            try {
                this.fileUploadThread = this.uploadPolicy.getPostURL().substring(0, 4).equals("ftp:") ? new FileUploadThreadFTP(this.uploadPolicy, packetQueue, this) : new FileUploadThreadHTTP(this.uploadPolicy, packetQueue, this);
            }
            catch (JUploadException e1) {
                this.uploadPolicy.displayErr(e1);
            }
        }
    }

    private void initProgressBar() throws JUploadException {
        this.preparationProgressBar.setMaximum(100 * this.filePanel.getFilesLength());
        this.preparationProgressBar.setString("");
        this.uploadProgressBar.setMaximum(100 * this.filePanel.getFilesLength());
        this.uploadProgressBar.setString("");
        this.updateUploadProgressBar(null, null);
    }
}

