/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Pattern;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.exception.JUploadInterrupted;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultFileUploadThread
extends Thread
implements FileUploadThread {
    BlockingQueue<UploadFilePacket> packetQueue = null;
    FileUploadManagerThread fileUploadManagerThread = null;
    protected UploadPolicy uploadPolicy = null;
    private long maxChunkSize;
    protected String responseMsg = "";
    protected String responseBody = "";

    public DefaultFileUploadThread(String threadName, BlockingQueue<UploadFilePacket> packetQueue, UploadPolicy uploadPolicy, FileUploadManagerThread fileUploadManagerThread) {
        super(threadName);
        this.packetQueue = packetQueue;
        this.uploadPolicy = uploadPolicy;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.maxChunkSize = this.uploadPolicy.getMaxChunkSize();
        this.uploadPolicy.displayDebug("DefaultFileUploadThread created", 30);
    }

    abstract long getAdditionnalBytesForUpload(UploadFileData var1) throws JUploadIOException;

    abstract void beforeRequest(UploadFilePacket var1) throws JUploadException;

    abstract void startRequest(long var1, boolean var3, int var4, boolean var5) throws JUploadException;

    abstract int finishRequest() throws JUploadException;

    abstract void interruptionReceived();

    abstract void beforeFile(UploadFilePacket var1, UploadFileData var2) throws JUploadException;

    abstract void afterFile(UploadFileData var1) throws JUploadException;

    abstract void cleanRequest() throws JUploadException;

    abstract void cleanAll() throws JUploadException;

    abstract OutputStream getOutputStream() throws JUploadException;

    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String getResponseMsg() {
        return this.responseMsg;
    }

    @Override
    public BlockingQueue<UploadFilePacket> getPacketQueue() {
        return this.packetQueue;
    }

    void setResponseBody(String body) {
        this.responseBody = this.normalizeCRLF(body);
    }

    void setResponseMsg(String msg) {
        this.responseMsg = this.normalizeCRLF(msg);
    }

    @Override
    public final void run() {
        this.uploadPolicy.displayDebug("Start of the FileUploadThread", 5);
        while (!this.fileUploadManagerThread.isUploadFinished()) {
            try {
                UploadFilePacket packet = this.packetQueue.take();
                if (packet.isPoisonned()) break;
                this.doUpload(packet);
                this.uploadPolicy.displayDebug("After do upload", 5);
            }
            catch (InterruptedException e) {
                this.uploadPolicy.displayWarn(this.getClass().getName() + ".run(): received in " + e.getClass().getName() + ", exiting...");
                break;
            }
            catch (JUploadException e) {
                this.fileUploadManagerThread.setUploadException(e);
            }
            catch (JUploadInterrupted e) {
                this.uploadPolicy.displayInfo("Upload stopped by the user");
                this.uploadPolicy.displayDebug(e.getMessage(), 30);
            }
        }
        this.uploadPolicy.displayDebug("End of the FileUploadThread", 5);
    }

    private final void doUpload(UploadFilePacket packet) throws JUploadException, JUploadInterrupted {
        boolean bChunkEnabled = false;
        long totalContentLength = 0L;
        long totalFileLength = 0L;
        this.fileUploadManagerThread.setUploadStatus(packet, (UploadFileData)packet.get(0), 2);
        this.beforeRequest(packet);
        for (UploadFileData uploadFileData : packet) {
            totalContentLength += uploadFileData.getUploadLength();
            totalContentLength += this.getAdditionnalBytesForUpload(uploadFileData);
            totalFileLength += uploadFileData.getUploadLength();
            this.uploadPolicy.displayDebug("file " + uploadFileData.getFileName() + ": content=" + uploadFileData.getUploadLength() + " bytes, getAdditionnalBytesForUpload=" + this.getAdditionnalBytesForUpload(uploadFileData) + " bytes", 50);
        }
        if (totalFileLength >= this.maxChunkSize) {
            if (packet.size() > 1) {
                this.fileUploadManagerThread.setUploadException(new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should be 1 (doUpload)"));
            }
            bChunkEnabled = true;
        }
        if (bChunkEnabled) {
            if (packet.size() > 1) {
                throw new JUploadException("totalContentLength >= chunkSize: this.filesToUpload.length should not be more than 1 (doUpload)");
            }
            this.doChunkedUpload(packet);
        } else {
            this.doNonChunkedUpload(packet, totalContentLength, totalFileLength);
        }
        this.fileUploadManagerThread.currentRequestIsFinished(packet);
    }

    private final void doChunkedUpload(UploadFilePacket packet) throws JUploadException, JUploadInterrupted {
        boolean bLastChunk = false;
        int chunkPart = 0;
        long contentLength = 0L;
        long thisChunkSize = 0L;
        if (packet.size() > 1) {
            throw new JUploadException("doChunkedUpload called with a packet of more than 1 file (" + packet.size() + " files)");
        }
        UploadFileData uploadFileData = (UploadFileData)packet.get(0);
        try {
            try {
                while (!bLastChunk && !this.fileUploadManagerThread.isUploadFinished()) {
                    bLastChunk = contentLength > uploadFileData.getRemainingLength();
                    thisChunkSize = bLastChunk ? uploadFileData.getRemainingLength() : this.maxChunkSize;
                    contentLength = thisChunkSize + this.getAdditionnalBytesForUpload(uploadFileData);
                    this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 2);
                    this.startRequest(contentLength, true, ++chunkPart, bLastChunk);
                    this.beforeFile(packet, uploadFileData);
                    uploadFileData.uploadFile(this.getOutputStream(), thisChunkSize);
                    if (bLastChunk && uploadFileData.getRemainingLength() > 0L) {
                        throw new JUploadExceptionUploadFailed("Files has not be entirely uploaded. The remaining size is " + uploadFileData.getRemainingLength() + " bytes. File size was: " + uploadFileData.getUploadLength() + " bytes.");
                    }
                    this.afterFile(uploadFileData);
                    int status = this.finishRequest();
                    if (bLastChunk) {
                        this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 4);
                    } else {
                        this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 3);
                    }
                    this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
                    this.cleanRequest();
                }
                this.fileUploadManagerThread.anotherFileHasBeenSent(packet, uploadFileData);
            }
            catch (JUploadInterrupted e) {
                this.interruptionReceived();
                throw e;
            }
            Object var11_9 = null;
            if (uploadFileData.isPreparedForUpload()) {
                uploadFileData.afterUpload();
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (uploadFileData.isPreparedForUpload()) {
                uploadFileData.afterUpload();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doNonChunkedUpload(UploadFilePacket packet, long totalContentLength, long totalFileLength) throws JUploadException, JUploadInterrupted {
        this.startRequest(totalContentLength, false, 0, true);
        for (UploadFileData uploadFileData : packet) {
            Object var9_7;
            if (this.fileUploadManagerThread.isUploadFinished()) break;
            this.fileUploadManagerThread.setUploadStatus(packet, uploadFileData, 2);
            try {
                this.beforeFile(packet, uploadFileData);
                if (!this.fileUploadManagerThread.isUploadFinished()) {
                    uploadFileData.uploadFile(this.getOutputStream(), uploadFileData.getUploadLength());
                }
                var9_7 = null;
                if (uploadFileData.isPreparedForUpload()) {
                    uploadFileData.afterUpload();
                }
            }
            catch (Throwable throwable) {
                var9_7 = null;
                if (uploadFileData.isPreparedForUpload()) {
                    uploadFileData.afterUpload();
                }
                throw throwable;
            }
            if (this.fileUploadManagerThread.isUploadFinished()) continue;
            this.afterFile(uploadFileData);
            this.fileUploadManagerThread.anotherFileHasBeenSent(packet, uploadFileData);
        }
        if (!this.fileUploadManagerThread.isUploadFinished()) {
            this.fileUploadManagerThread.setUploadStatus(packet, (UploadFileData)packet.get(packet.size() - 1), 4);
            int status = this.finishRequest();
            this.uploadPolicy.checkUploadSuccess(status, this.getResponseMsg(), this.getResponseBody());
        }
        this.cleanRequest();
    }

    @Override
    public void close() {
        try {
            this.cleanAll();
        }
        catch (JUploadException e) {
            this.uploadPolicy.displayErr(e);
        }
    }

    public final String normalizeCRLF(String s) {
        Pattern p = Pattern.compile("\\r\\n|\\r|\\n", 8);
        String[] lines = p.split(s);
        StringBuffer sb = new StringBuffer(s.length() * 2);
        for (int i = 0; i < lines.length; ++i) {
            sb.append(lines[i]).append("\r\n");
        }
        return sb.toString();
    }

    public final String quoteCRLF(String s) {
        return s.replaceAll("\r\n", "\\\\r\\\\n\n");
    }

    @Override
    public void setFileUploadThreadManager(FileUploadManagerThread fileUploadManagerThread) throws JUploadException {
        if (this.fileUploadManagerThread != null) {
            throw new JUploadException("Can not override fileUploadManagerThread (in DefaultFileUpload.setFileUploadThreadManager()");
        }
        this.fileUploadManagerThread = fileUploadManagerThread;
    }
}

