/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.exception.JUploadInterrupted;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.UploadFileDataPoisonned;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;

public class UploadFileData
implements FileData {
    private FileData fileData = null;
    int numOfFileInCurrentRequest = -1;
    private FileUploadManagerThread fileUploadManagerThread = null;
    private InputStream inputStream = null;
    private long uploadRemainingLength = -1L;
    private UploadPolicy uploadPolicy = null;
    private static final int BUFLEN = 4096;
    private final byte[] readBuffer = new byte[4096];

    public UploadFileData(FileData fileDataParam, int numOfFileInCurrentRequest, FileUploadManagerThread fileUploadThreadParam, UploadPolicy uploadPolicyParam) {
        if (fileDataParam == null && !(this instanceof UploadFileDataPoisonned)) {
            throw new NullPointerException("fileData is null in UploadFileData(FileData, FileUploadManagerThread, UploadPolicy) constructor");
        }
        this.fileData = fileDataParam;
        this.numOfFileInCurrentRequest = numOfFileInCurrentRequest;
        this.fileUploadManagerThread = fileUploadThreadParam;
        this.uploadPolicy = uploadPolicyParam;
    }

    public UploadFileData(boolean poisonned) {
        if (!poisonned) {
            throw new IllegalArgumentException("poisonned must be true in UploadFileData(boolean) constructor");
        }
    }

    long getRemainingLength() {
        return this.uploadRemainingLength;
    }

    String getMD5() throws JUploadException {
        StringBuffer ret = new StringBuffer();
        MessageDigest digest = null;
        byte[] md5Buffer = new byte[4096];
        InputStream md5InputStream = this.fileData.getInputStream();
        try {
            int nbBytes;
            digest = MessageDigest.getInstance("MD5");
            while ((nbBytes = md5InputStream.read(md5Buffer, 0, 4096)) > 0) {
                digest.update(md5Buffer, 0, nbBytes);
            }
            md5InputStream.close();
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JUploadException(e);
        }
        byte[] md5sum = new byte[32];
        if (digest != null) {
            md5sum = digest.digest();
        }
        for (int i = 0; i < md5sum.length; ++i) {
            ret.append(Integer.toHexString(md5sum[i] >> 4 & 0xF));
            ret.append(Integer.toHexString(md5sum[i] & 0xF));
        }
        return ret.toString();
    }

    void uploadFile(OutputStream outputStream, long amount) throws JUploadException, JUploadInterrupted {
        this.uploadPolicy.displayDebug("in UploadFileData.uploadFile (amount:" + amount + ", getUploadLength(): " + this.getUploadLength() + ")", 30);
        this.getInputStream();
        while (amount > 0L && !this.fileUploadManagerThread.isUploadFinished()) {
            if (Thread.interrupted()) {
                throw new JUploadInterrupted(this.getClass().getName() + ".uploadFile [" + this.getFileName() + "]", this.uploadPolicy);
            }
            int toread = amount > 4096L ? 4096 : (int)amount;
            int towrite = 0;
            try {
                towrite = this.inputStream.read(this.readBuffer, 0, toread);
            }
            catch (IOException e) {
                throw new JUploadIOException(e);
            }
            if (towrite <= 0) continue;
            try {
                outputStream.write(this.readBuffer, 0, towrite);
                this.fileUploadManagerThread.nbBytesUploaded(towrite);
                amount -= (long)towrite;
                this.uploadRemainingLength -= (long)towrite;
                if (this.uploadPolicy.getDebugLevel() <= 100) continue;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {}
            }
            catch (IOException ioe) {
                throw new JUploadIOException(this.getClass().getName() + ".uploadFile()", ioe);
            }
            catch (Exception e) {
                throw new JUploadException(this.getClass().getName() + ".uploadFile()  (check the user permission on the server)", e);
            }
        }
    }

    public void afterUpload() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + ": " + e.getMessage() + " (in UploadFileData.afterUpload()");
            }
            this.inputStream = null;
        }
        this.fileData.afterUpload();
    }

    public void appendFileProperties(ByteArrayEncoder bae, int index) throws JUploadIOException {
        this.fileData.appendFileProperties(bae, index);
    }

    public void beforeUpload() throws JUploadException {
        this.fileData.beforeUpload();
        this.uploadRemainingLength = this.fileData.getUploadLength();
    }

    public boolean canRead() {
        return this.fileData.canRead();
    }

    public String getDirectory() {
        return this.fileData.getDirectory();
    }

    public File getFile() {
        return this.fileData.getFile();
    }

    public String getFileExtension() {
        return this.fileData.getFileExtension();
    }

    public long getFileLength() {
        return this.fileData.getFileLength();
    }

    public String getFileName() {
        return this.fileData.getFileName();
    }

    public InputStream getInputStream() throws JUploadException {
        if (this.inputStream == null) {
            if (this.uploadRemainingLength <= 0L) {
                this.uploadPolicy.displayWarn("[" + this.getFileName() + "] UploadFileData.getInputStream(): uploadRemainingLength is <= 0. Trying a new upload ?");
                this.uploadRemainingLength = this.fileData.getUploadLength();
            }
            this.inputStream = this.fileData.getInputStream();
        }
        return this.inputStream;
    }

    public Date getLastModified() {
        return this.fileData.getLastModified();
    }

    public String getMimeType() {
        return this.fileData.getMimeType();
    }

    public String getRelativeDir() {
        return this.fileData.getRelativeDir();
    }

    public String getUploadFilename(int index) throws JUploadException {
        return this.uploadPolicy.getUploadFilename(this.fileData, index);
    }

    public String getUploadName(int index) throws JUploadException {
        return this.uploadPolicy.getUploadName(this.fileData, index);
    }

    public long getUploadLength() {
        return this.fileData.getUploadLength();
    }

    public boolean isPreparedForUpload() {
        return this.fileData.isPreparedForUpload();
    }

    public boolean isPoisonned() {
        return false;
    }

    public int getNumOfFileInCurrentRequest() {
        return this.numOfFileInCurrentRequest;
    }
}

