/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import wjhk.jupload2.context.JUploadContext;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.filedata.PictureFileData;
import wjhk.jupload2.filedata.helper.ImageFileConversionInfo;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.image.JUploadImagePreview;
import wjhk.jupload2.gui.image.PictureDialog;
import wjhk.jupload2.gui.image.PicturePanel;
import wjhk.jupload2.policies.DefaultUploadPolicy;

public class PictureUploadPolicy
extends DefaultUploadPolicy
implements ActionListener,
ImageObserver {
    private boolean storeBufferedImage;
    private String targetPictureFormat;
    private boolean keepOrigExtension;
    private ImageFileConversionInfo imageFileConversionInfo = new ImageFileConversionInfo("");
    private boolean fileChooserImagePreview = true;
    private boolean highQualityPreview;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private float pictureCompressionQuality = 0.8f;
    private boolean pictureTransmitMetadata;
    private int realMaxWidth = -1;
    private int realMaxHeight = -1;
    private JButton rotateLeftButton;
    private JButton rotateRightButton;
    private PicturePanel picturePanel;

    public PictureUploadPolicy(JUploadContext juploadContext) throws JUploadException {
        super(juploadContext);
        this.setFileChooserImagePreview(juploadContext.getParameter("fileChooserImagePreview", true));
        this.setHighQualityPreview(juploadContext.getParameter("highQualityPreview", false));
        this.setMaxHeight(juploadContext.getParameter("maxPicHeight", Integer.MAX_VALUE));
        this.setMaxWidth(juploadContext.getParameter("maxPicWidth", Integer.MAX_VALUE));
        this.setPictureCompressionQuality(juploadContext.getParameter("pictureCompressionQuality", 0.8f));
        this.setPictureTransmitMetadata(juploadContext.getParameter("pictureTransmitMetadata", false));
        this.setRealMaxHeight(juploadContext.getParameter("realMaxPicHeight", Integer.MAX_VALUE));
        this.setRealMaxWidth(juploadContext.getParameter("realMaxPicWidth", Integer.MAX_VALUE));
        this.setTargetPictureFormat(juploadContext.getParameter("targetPictureFormat", DEFAULT_TARGET_PICTURE_FORMAT));
        this.setKeepOrigExtension(juploadContext.getParameter("keepOriginalFileExtensionForConvertedImages", false));
        this.displayDebug("[PictureUploadPolicy] end of constructor", 30);
    }

    public FileData createFileData(File file, File root) throws JUploadExceptionStopAddingFiles {
        FileData defaultFileData = super.createFileData(file, root);
        if (defaultFileData == null) {
            return null;
        }
        PictureFileData pfd = null;
        try {
            pfd = new PictureFileData(file, root, this);
        }
        catch (JUploadIOException e) {
            this.displayErr(e);
        }
        if (pfd != null && pfd.isPicture()) {
            return pfd;
        }
        if (this.getAllowedFileExtensions() != null) {
            return defaultFileData;
        }
        String msg = this.getLocalizedString("notAPicture", file.getName());
        this.displayWarn(msg);
        if (JOptionPane.showConfirmDialog(null, msg, "alert", 2, 2) == 2) {
            throw new JUploadExceptionStopAddingFiles("Stopped by the user");
        }
        return null;
    }

    public JPanel createTopPanel(JButton browse, JButton remove, JButton removeAll, JUploadPanel jUploadPanel) {
        this.rotateLeftButton = new JButton(this.getLocalizedString("buttonRotateLeft", new Object[0]));
        this.rotateLeftButton.setIcon(new ImageIcon(this.getClass().getResource("/images/rotateLeft.gif")));
        this.rotateLeftButton.addActionListener(this);
        this.rotateLeftButton.addMouseListener(jUploadPanel);
        this.rotateLeftButton.setEnabled(false);
        this.rotateRightButton = new JButton(this.getLocalizedString("buttonRotateRight", new Object[0]));
        this.rotateRightButton.setIcon(new ImageIcon(this.getClass().getResource("/images/rotateRight.gif")));
        this.rotateRightButton.addActionListener(this);
        this.rotateRightButton.addMouseListener(jUploadPanel);
        this.rotateRightButton.setEnabled(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(5, 1, 5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        buttonPanel.add(browse);
        buttonPanel.add(this.rotateLeftButton);
        buttonPanel.add(this.rotateRightButton);
        buttonPanel.add(removeAll);
        buttonPanel.add(remove);
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new GridLayout(1, 1));
        pPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        this.picturePanel = new PicturePanel(true, this);
        this.picturePanel.addMouseListener(jUploadPanel);
        pPanel.add(this.picturePanel);
        this.setCursor(null);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(1, 2));
        topPanel.add(buttonPanel);
        topPanel.add(pPanel);
        jUploadPanel.setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        return topPanel;
    }

    public void actionPerformed(ActionEvent e) {
        this.displayInfo("Action : " + e.getActionCommand());
        if (e.getActionCommand() == this.rotateLeftButton.getActionCommand()) {
            this.picturePanel.rotate(-1);
        } else if (e.getActionCommand() == this.rotateRightButton.getActionCommand()) {
            this.picturePanel.rotate(1);
        }
    }

    public void onFileSelected(FileData fileData) {
        if (fileData != null) {
            this.displayDebug("File selected: " + fileData.getFileName(), 30);
        }
        if (this.picturePanel != null) {
            if (fileData instanceof PictureFileData) {
                Cursor previousCursor = this.setWaitCursor();
                this.picturePanel.setPictureFile((PictureFileData)fileData, this.rotateLeftButton, this.rotateRightButton);
                this.setCursor(previousCursor);
            } else {
                this.picturePanel.setPictureFile(null, this.rotateLeftButton, this.rotateRightButton);
            }
        }
    }

    public void onFileDoubleClicked(FileData pictureFileData) {
        if (pictureFileData != null) {
            if (!(pictureFileData instanceof PictureFileData)) {
                this.displayWarn("PictureUploadPolicy: received a non PictureFileData in onFileDoubleClicked");
            } else {
                new PictureDialog(null, (PictureFileData)pictureFileData, this);
            }
        }
    }

    public boolean beforeUpload() {
        this.getContext().getUploadPanel().getFilePanel().clearSelection();
        if (this.picturePanel != null) {
            this.picturePanel.setPictureFile(null, this.rotateLeftButton, this.rotateRightButton);
        }
        return super.beforeUpload();
    }

    public boolean getFileChooserImagePreview() {
        return this.fileChooserImagePreview;
    }

    public void setFileChooserImagePreview(boolean fileChooserImagePreview) {
        this.fileChooserImagePreview = fileChooserImagePreview;
    }

    public boolean getHighQualityPreview() {
        return this.highQualityPreview;
    }

    void setHighQualityPreview(boolean highQualityPreview) {
        this.highQualityPreview = highQualityPreview;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    void setMaxHeight(int maxHeight) {
        if (maxHeight <= 0) {
            this.maxHeight = Integer.MAX_VALUE;
            this.displayWarn("[setMaxHeight] maxHeight switched from " + maxHeight + " to " + this.maxHeight);
        } else {
            this.maxHeight = maxHeight;
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    void setMaxWidth(int maxWidth) {
        if (maxWidth <= 0) {
            this.maxWidth = Integer.MAX_VALUE;
            this.displayWarn("[setMaxWidth] maxWidth switched from " + maxWidth + " to " + this.maxWidth);
        } else {
            this.maxWidth = maxWidth;
        }
    }

    public float getPictureCompressionQuality() {
        return this.pictureCompressionQuality;
    }

    void setPictureCompressionQuality(float pictureCompressionQuality) {
        this.pictureCompressionQuality = pictureCompressionQuality;
    }

    public boolean getPictureTransmitMetadata() {
        return this.pictureTransmitMetadata;
    }

    void setPictureTransmitMetadata(boolean pictureTransmitMetadata) {
        this.pictureTransmitMetadata = pictureTransmitMetadata;
    }

    public int getRealMaxHeight() {
        return this.realMaxHeight == Integer.MAX_VALUE ? this.maxHeight : this.realMaxHeight;
    }

    void setRealMaxHeight(int realMaxHeight) {
        this.realMaxHeight = realMaxHeight;
    }

    public int getRealMaxWidth() {
        return this.realMaxWidth == Integer.MAX_VALUE ? this.maxWidth : this.realMaxWidth;
    }

    void setRealMaxWidth(int realMaxWidth) {
        this.realMaxWidth = realMaxWidth;
    }

    public String getTargetPictureFormat() {
        return this.targetPictureFormat;
    }

    public ImageFileConversionInfo getImageFileConversionInfo() {
        return this.imageFileConversionInfo;
    }

    void setTargetPictureFormat(String targetPictureFormat) throws JUploadException {
        this.targetPictureFormat = targetPictureFormat;
        this.imageFileConversionInfo = new ImageFileConversionInfo(targetPictureFormat);
    }

    public boolean getKeepOrigExtension() {
        return this.keepOrigExtension;
    }

    void setKeepOrigExtension(boolean keepOrigExtension) throws JUploadException {
        this.keepOrigExtension = keepOrigExtension;
    }

    public void setProperty(String prop, String value) throws JUploadException {
        if (prop.equals("fileChooserImagePreview")) {
            this.setFileChooserImagePreview(this.getContext().parseBoolean(value, this.getFileChooserImagePreview()));
        } else if (prop.equals("highQualityPreview")) {
            this.setHighQualityPreview(this.getContext().parseBoolean(value, this.highQualityPreview));
        } else if (prop.equals("maxPicHeight")) {
            this.setMaxHeight(this.getContext().parseInt(value, this.maxHeight));
        } else if (prop.equals("maxPicWidth")) {
            this.setMaxWidth(this.getContext().parseInt(value, this.maxWidth));
        } else if (prop.equals("pictureCompressionQuality")) {
            this.setPictureCompressionQuality(this.getContext().parseFloat(value, this.pictureCompressionQuality));
        } else if (prop.equals("pictureTransmitMetadata")) {
            this.setPictureTransmitMetadata(this.getContext().parseBoolean(value, this.pictureTransmitMetadata));
        } else if (prop.equals("realMaxPicHeight")) {
            this.setRealMaxHeight(this.getContext().parseInt(value, this.realMaxHeight));
        } else if (prop.equals("realMaxPicWidth")) {
            this.setRealMaxWidth(this.getContext().parseInt(value, this.realMaxWidth));
        } else if (prop.equals("targetPictureFormat")) {
            this.setTargetPictureFormat(value);
        } else if (prop.equals("keepOriginalFileExtensionForConvertedImages")) {
            this.setKeepOrigExtension(this.getContext().parseBoolean(value, this.keepOrigExtension));
        } else {
            super.setProperty(prop, value);
        }
    }

    public void displayParameterStatus() {
        super.displayParameterStatus();
        this.displayDebug("======= Parameters managed by PictureUploadPolicy", 30);
        this.displayDebug("fileChooserImagePreview: " + this.getFileChooserImagePreview(), 30);
        this.displayDebug("highQualityPreview : " + this.highQualityPreview, 30);
        this.displayDebug("pictureCompressionQuality : " + this.getPictureCompressionQuality(), 30);
        this.displayDebug("pictureTransmitMetadata : " + this.getPictureTransmitMetadata(), 30);
        this.displayDebug("maxPicWidth : " + this.maxWidth + ", " + "maxPicHeight" + " : " + this.maxHeight, 30);
        this.displayDebug("realMaxPicWidth : " + this.realMaxWidth + ", " + "realMaxPicHeight" + " : " + this.realMaxHeight, 30);
        this.displayDebug("storeBufferedImage : " + this.storeBufferedImage, 30);
        this.displayDebug("targetPictureFormat : " + this.targetPictureFormat, 30);
        this.displayDebug("Format conversions : " + this.getImageFileConversionInfo(), 40);
        this.displayDebug("", 30);
    }

    public Cursor setWaitCursor() {
        Cursor previousCursor = super.setWaitCursor();
        this.picturePanel.setCursor(null);
        return previousCursor;
    }

    public Cursor setCursor(Cursor cursor) {
        Cursor oldCursor = super.setCursor(null);
        this.picturePanel.setCursor(new Cursor(12));
        return oldCursor;
    }

    public JUploadFileChooser createFileChooser() {
        JUploadFileChooser jufc = super.createFileChooser();
        if (this.getFileChooserImagePreview()) {
            jufc.setAccessory(new JUploadImagePreview(jufc, this));
        }
        return jufc;
    }

    public Icon fileViewGetIcon(File file) {
        return PictureFileData.getImageIcon(file, this.getFileChooserIconSize(), this.getFileChooserIconSize());
    }

    public String getUploadFilename(FileData fileData, int index) throws JUploadException {
        String targetFormatOrNull;
        String fileName = fileData.getFileName();
        if (!this.keepOrigExtension && (targetFormatOrNull = this.imageFileConversionInfo.getTargetFormatOrNull(fileData.getFileExtension())) != null) {
            int endIndex = fileName.length() - fileData.getFileExtension().length();
            StringBuilder newFilename = new StringBuilder(fileName.substring(0, endIndex));
            newFilename.append(targetFormatOrNull);
            fileName = newFilename.toString();
        }
        return this.getEncodedFilename(fileName);
    }

    public boolean imageUpdate(Image arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
        return true;
    }
}

