<?php

  /**
 * This is the jfusion user plugin file
 *
 * PHP version 5
 *
 * @category   JFusion
 * @package    Plugins
 * @subpackage Search
 * @author     JFusion Team <webmaster@jfusion.org>
 * @copyright  2008 JFusion. All rights reserved.
 * @license    http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link       http://www.jfusion.org
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
/**
 * Load the JFusion framework
 */
require_once JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'model.factory.php';
require_once JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_jfusion' . DS . 'models' . DS . 'model.jfusion.php';
$mainframe = & JFactory::getApplication();
$mainframe->registerEvent('onSearch', 'plgSearchjfusion');
$mainframe->registerEvent('onSearchAreas', 'plgSearchjfusionAreas');
JPlugin::loadLanguage('plg_search_jfusion');
//get the name of each plugin and add to areas

/**
 * Called by joomla framework define the area that can be search in
 *
 * @return array search areas
 */
function &plgSearchjfusionAreas()
{
    static $areas = array();
    //get the softwares with search enabled
    $plugins = JFusionFunction::getPlugins('search');
    $searchplugin = & JPluginHelper::getPlugin('search', 'jfusion');
    $params = new JParameter($searchplugin->params);
    $enabledPlugins = unserialize(base64_decode($params->get('JFusionPluginParam')));
    if (is_array($plugins)) {
        foreach ($plugins as $plugin) {
            if (is_array($enabledPlugins) && array_key_exists($plugin->name, $enabledPlugins)) {
                if ($plugin->name != "joomla_int") {
                    //make sure that search is enabled
                    $public = & JFusionFactory::getPublic($plugin->name);
                    $title = (!empty($enabledPlugins[$plugin->name]['title'])) ? $enabledPlugins[$plugin->name]['title'] : $plugin->name;
                    $areas[$plugin->name] = $title;
                }
            }
        }
    }
    return $areas;
}
/**
 * Search Function Called by the joomla framework
 *
 * @param string $text     Search text
 * @param string $phrase   Phrases
 * @param string $ordering How to order the search results
 * @param array  $areas    What area to search
 *
 * @return array with results
 */
function plgSearchjfusion($text, $phrase = '', $ordering = '', $areas = null)
{
    //no text to search
    if (!$text) {
        return array();
    }
    $searchPlugins = plgSearchjfusionAreas();
    if (is_array($areas)) {
        //jfusion plugins to search
        $searchPlugins = array_intersect($areas, array_keys($searchPlugins));
        if (empty($searchPlugins)) {
            return array();
        }
    } else {
        //we need to extract the keys since they are the jnames
        $searchPlugins = array_keys($searchPlugins);
    }
    //get the search plugin parameters
    $plugin = & JPluginHelper::getPlugin('search', 'jfusion');
    $params = new JParameter($plugin->params);
    $pluginParamValue = $params->get('JFusionPluginParam');
    $pluginParamValue = unserialize(base64_decode($pluginParamValue));
    //To hold all the search results
    $searchResults = array();
    foreach ($searchPlugins AS $key => $jname) {
        $searchMe = & JFusionFactory::getPublic($jname);
        if (is_array($pluginParamValue)) {
            $pluginParam = new JParameter('');
            $pluginParam->loadArray($pluginParamValue[$jname]);
        } else {
            $pluginParam = new JParameter('');
        }
        $itemid = & $pluginParam->get('itemid');
        $results = $searchMe->getSearchResults($text, $phrase, $pluginParam, $itemid);
        if (is_array($results)) {
        	$searchResults = array_merge($searchResults, $results);
    	}
    }
    //sort the results
    jimport('joomla.utilities.array');
    switch ($ordering) {
    case 'oldest':
            JArrayHelper::sortObjects($searchResults, 'created');
        break;
    case 'category':
            JArrayHelper::sortObjects($searchResults, 'section');
        break;
    case 'alpha':
            JArrayHelper::sortObjects($searchResults, 'title');
        break;
    case 'newest':
    default:
            JArrayHelper::sortObjects($searchResults, 'created', -1);
        break;
    }
    return $searchResults;
}
