/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.util.concurrent.BlockingQueue;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;
import wjhk.jupload2.upload.UploadFilePacketPoisonned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketConstructionThread
extends Thread {
    UploadPolicy uploadPolicy = null;
    FileUploadManagerThread fileUploadManagerThread = null;
    BlockingQueue<UploadFileData> preparedFileQueue = null;
    BlockingQueue<UploadFilePacket> packetQueue = null;
    UploadFilePacket packetInProgress = null;
    boolean lastFileReceived = false;

    PacketConstructionThread(BlockingQueue<UploadFileData> preparedFileQueue, BlockingQueue<UploadFilePacket> packetQueue, FileUploadManagerThread fileUploadManagerThread, UploadPolicy uploadPolicy) {
        super("PacketConstructionThread");
        this.preparedFileQueue = preparedFileQueue;
        this.packetQueue = packetQueue;
        this.fileUploadManagerThread = fileUploadManagerThread;
        this.uploadPolicy = uploadPolicy;
        this.packetInProgress = new UploadFilePacket(this.uploadPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            try {
                while (!this.lastFileReceived && !this.fileUploadManagerThread.isUploadFinished()) {
                    UploadFileData ufd = this.preparedFileQueue.take();
                    this.receiveNewFile(ufd);
                }
                if (this.packetInProgress.size() > 0) {
                    this.sendCurrentPacket();
                }
            }
            catch (InterruptedException e) {
                this.uploadPolicy.displayWarn("packetConstructionThread received InterruptedException, exiting");
            }
            if (!this.preparedFileQueue.isEmpty()) {
                if (!this.fileUploadManagerThread.isUploadFinished()) {
                    this.uploadPolicy.displayWarn("The preparedFileQueue is not empty, at the end of " + this.getClass().getName());
                }
                while (!this.preparedFileQueue.isEmpty()) {
                    this.preparedFileQueue.poll();
                }
            }
        }
        catch (JUploadException e) {
            this.fileUploadManagerThread.setUploadException(e);
        }
        finally {
            try {
                this.packetQueue.put(new UploadFilePacketPoisonned(this.uploadPolicy));
            }
            catch (InterruptedException e) {
                this.uploadPolicy.displayWarn("packetConstructionThread received InterruptedException, exiting");
            }
        }
    }

    private void receiveNewFile(UploadFileData uploadFileData) throws JUploadException, InterruptedException {
        if (uploadFileData.isPoisonned()) {
            this.lastFileReceived = true;
        } else {
            if (!this.packetInProgress.add(uploadFileData)) {
                this.sendCurrentPacket();
                if (!this.packetInProgress.add(uploadFileData)) {
                    throw new JUploadException("Could not add file to packet! (filename: " + uploadFileData.getFileName() + ")");
                }
            }
            if (this.packetInProgress.isFull()) {
                this.sendCurrentPacket();
            }
        }
    }

    private void sendCurrentPacket() throws InterruptedException {
        if (this.packetInProgress == null) {
            throw new AssertionError((Object)(this.getClass().getName() + ".sendCurrentPacket(): this.packetInProgress may not be null"));
        }
        if (this.packetInProgress.size() == 0) {
            throw new AssertionError((Object)(this.getClass().getName() + ".sendCurrentPacket(): this.packetInProgress.size() may not be 0"));
        }
        this.packetQueue.put(this.packetInProgress);
        this.packetInProgress = new UploadFilePacket(this.uploadPolicy);
    }
}

